/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.RegistryEntries;

public class TileEternalWater
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final FluidStack WATER = new FluidStack((Fluid)Fluids.field_204546_a, Integer.MAX_VALUE);
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);

    public TileEternalWater() {
        super(RegistryEntries.TILE_ENTITY_ETERNAL_WATER);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(InfiniteWaterFluidCapability::new));
    }

    protected void updateTileEntity() {
        if (!this.func_145831_w().func_201670_d()) {
            for (Direction direction : Direction.values()) {
                TileHelpers.getCapability((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(direction), (Direction)direction.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> handler.fill(WATER, IFluidHandler.FluidAction.EXECUTE));
            }
        }
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    public static class InfiniteWaterFluidCapability
    implements IFluidHandler {
        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return WATER;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getFluid() != WATER.getFluid()) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(WATER.getFluid(), resource.getAmount());
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack(WATER.getFluid(), maxDrain);
        }
    }
}

