/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierActionRegistry;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.TankInventoryTileEntity;

public class TilePurifier
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final int SLOTS = 2;
    public static final int SLOT_PURIFY = 0;
    public static final int SLOT_ADDITIONAL = 1;
    private static final int ANIMATION_FINISHED_DURATION = 2;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private Float randomRotation = Float.valueOf(0.0f);
    private int tick = 0;
    public static final int MAX_BUCKETS = 3;
    @NBTPersist
    public Integer tickCount = 0;
    @NBTPersist
    public Float additionalRotation2 = Float.valueOf(0.0f);
    @NBTPersist
    public Float additionalRotationPrev = Float.valueOf(0.0f);
    @NBTPersist
    public Float additionalRotation = Float.valueOf(0.0f);
    @NBTPersist
    private Integer finishedAnimation = 0;
    @NBTPersist
    private Integer currentAction = -1;
    public int field_195522_a;
    public float field_195523_f;
    public float field_195524_g;
    public float field_195525_h;
    public float field_195526_i;
    public float field_195527_j;
    public float field_195528_k;
    public float field_195529_l;
    public float field_195530_m;
    public float field_195531_n;

    public TilePurifier() {
        super(RegistryEntries.TILE_ENTITY_PURIFIER, 2, 1, 3000, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.getInventory().addDirtyMarkListener(() -> ((TilePurifier)this).sendUpdate());
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean func_94041_b(int i, ItemStack itemStack) {
                if (i == 0) {
                    return itemStack.func_190916_E() == 1 && TilePurifier.this.getActions().isItemValidForMainSlot(itemStack);
                }
                if (i == 1) {
                    return itemStack.func_190916_E() == 1 && TilePurifier.this.getActions().isItemValidForAdditionalSlot(itemStack);
                }
                return false;
            }
        };
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    public IPurifierActionRegistry getActions() {
        return (IPurifierActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IPurifierActionRegistry.class);
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        int actionId = this.currentAction;
        if (actionId < 0) {
            actionId = this.getActions().canWork(this);
        }
        if (actionId >= 0) {
            ++this.tick;
            if (this.getActions().work(actionId, this)) {
                this.tick = 0;
                this.currentAction = -1;
                this.onActionFinished();
            }
        } else {
            this.tick = 0;
            this.currentAction = -1;
        }
        if (this.finishedAnimation > 0) {
            Integer n = this.finishedAnimation;
            Integer n2 = this.finishedAnimation = Integer.valueOf(this.finishedAnimation - 1);
            if (this.field_145850_b.func_201670_d()) {
                this.showEnchantedEffect();
            }
        }
        this.updateAdditionalItem();
    }

    public void onActionFinished() {
        this.finishedAnimation = 2;
    }

    public int getBucketsFloored() {
        return (int)Math.floor((double)this.getTank().getFluidAmount() / 1000.0);
    }

    public int getBucketsRest() {
        return this.getTank().getFluidAmount() % 1000;
    }

    public void setBuckets(int buckets, int rest) {
        this.getTank().setFluid(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, 1000 * buckets + rest));
        this.sendUpdate();
    }

    public int getMaxBuckets() {
        return 3;
    }

    private void updateAdditionalItem() {
        float f2;
        float baseNextRotation;
        this.additionalRotationPrev = this.additionalRotation2;
        TilePurifier tilePurifier = this;
        tilePurifier.additionalRotation = Float.valueOf(tilePurifier.additionalRotation.floatValue() + 0.02f);
        while (this.additionalRotation2.floatValue() >= (float)Math.PI) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation2.floatValue() - (float)Math.PI * 2);
            tilePurifier.additionalRotation2 = tilePurifier.additionalRotation2;
        }
        while (this.additionalRotation2.floatValue() < (float)(-Math.PI)) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation2.floatValue() + (float)Math.PI * 2);
            tilePurifier.additionalRotation2 = tilePurifier.additionalRotation2;
        }
        while (this.additionalRotation.floatValue() >= (float)Math.PI) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation.floatValue() - (float)Math.PI * 2);
            tilePurifier.additionalRotation = tilePurifier.additionalRotation;
        }
        while (this.additionalRotation.floatValue() < (float)(-Math.PI)) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation.floatValue() + (float)Math.PI * 2);
            tilePurifier.additionalRotation = tilePurifier.additionalRotation;
        }
        for (baseNextRotation = this.additionalRotation.floatValue() - this.additionalRotation2.floatValue(); baseNextRotation >= (float)Math.PI; baseNextRotation -= (float)Math.PI * 2) {
        }
        while (baseNextRotation < (float)(-Math.PI)) {
            baseNextRotation += (float)Math.PI * 2;
        }
        TilePurifier tilePurifier2 = this;
        tilePurifier2.additionalRotation2 = Float.valueOf(tilePurifier2.additionalRotation2.floatValue() + baseNextRotation * 0.4f);
        tilePurifier2 = this;
        tilePurifier2.tickCount = tilePurifier2.tickCount + 1;
        for (f2 = this.field_195531_n - this.field_195529_l; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.field_195529_l += f2 * 0.4f;
        this.field_195527_j = MathHelper.func_76131_a((float)this.field_195527_j, (float)0.0f, (float)1.0f);
        ++this.field_195522_a;
        this.field_195524_g = this.field_195523_f;
        float f = (this.field_195525_h - this.field_195523_f) * 0.4f;
        float f3 = 0.2f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.field_195526_i += (f - this.field_195526_i) * 0.9f;
        this.field_195523_f += this.field_195526_i;
    }

    public ItemStack getPurifyItem() {
        return this.getInventory().func_70301_a(0);
    }

    public void setPurifyItem(ItemStack itemStack) {
        this.randomRotation = Float.valueOf(this.field_145850_b.field_73012_v.nextFloat() * 360.0f);
        this.getInventory().func_70299_a(0, itemStack);
    }

    public ItemStack getAdditionalItem() {
        return this.getInventory().func_70301_a(1);
    }

    public void setAdditionalItem(ItemStack itemStack) {
        this.getInventory().func_70299_a(1, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showEffect() {
        for (int i = 0; i < 1; ++i) {
            double particleX = (double)this.func_174877_v().func_177958_n() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double particleY = (double)this.func_174877_v().func_177956_o() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double particleZ = (double)this.func_174877_v().func_177952_p() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            float particleMotionX = -0.01f + this.field_145850_b.field_73012_v.nextFloat() * 0.02f;
            float particleMotionY = 0.01f;
            float particleMotionZ = -0.01f + this.field_145850_b.field_73012_v.nextFloat() * 0.02f;
            Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)RegistryEntries.PARTICLE_BLOOD_BUBBLE, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showEnchantingEffect() {
        if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
            for (int i = 0; i < 1; ++i) {
                double particleX = (double)this.func_174877_v().func_177958_n() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
                double particleY = (double)this.func_174877_v().func_177956_o() + 1.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
                double particleZ = (double)this.func_174877_v().func_177952_p() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
                float particleMotionX = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
                float particleMotionY = -this.field_145850_b.field_73012_v.nextFloat();
                float particleMotionZ = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
                Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)ParticleTypes.field_197623_p, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showEnchantedEffect() {
        for (int i = 0; i < 100; ++i) {
            double particleX = (double)this.func_174877_v().func_177958_n() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
            double particleY = (double)this.func_174877_v().func_177956_o() + 1.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
            double particleZ = (double)this.func_174877_v().func_177952_p() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
            float particleMotionX = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
            float particleMotionY = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
            float particleMotionZ = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
            Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)RegistryEntries.PARTICLE_MAGIC_FINISH, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public float getRandomRotation() {
        return this.randomRotation.floatValue();
    }

    @Override
    public void onTankChanged() {
        super.onTankChanged();
        this.sendUpdate();
    }

    public int getTick() {
        return this.tick;
    }

    public Integer getCurrentAction() {
        return this.currentAction;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

