/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.fluid.VirtualTank;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.TileEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;

public class TileSanguinaryEnvironmentalAccumulator
extends TileWorking<TileSanguinaryEnvironmentalAccumulator, MutableInt>
implements VirtualTank.ITankProvider,
INamedContainerProvider {
    public static final int SLOTS = 2;
    public static final int SLOT_ACCUMULATE = 0;
    public static final int SLOT_ACCUMULATE_RESULT = 1;
    public static Metadata METADATA = new Metadata();
    private static final int TANK_CHECK_TICK_OFFSET = 60;
    private int accumulateTicker;
    private SingleCache<Triple<ItemStack, FluidStack, WeatherType>, Optional<RecipeEnvironmentalAccumulator>> recipeCache;
    private VirtualTank virtualTank;
    private boolean forceLoadTanks;
    private List<BlockPos> invalidLocations = Lists.newArrayList();
    private static final Map<Class<?>, ITickAction<TileSanguinaryEnvironmentalAccumulator>> ACCUMULATE_TICK_ACTIONS = new LinkedHashMap();
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private static final BlockPos[] tankOffsets;

    public TileSanguinaryEnvironmentalAccumulator() {
        super(RegistryEntries.TILE_ENTITY_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR, 2, 64, 0, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.accumulateTicker = this.addTicker(new TickComponent<TileSanguinaryEnvironmentalAccumulator, ITickAction<TileSanguinaryEnvironmentalAccumulator>>(this, ACCUMULATE_TICK_ACTIONS, 0));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSanguinaryEnvironmentalAccumulator, MutableInt>(2.0){

            @Override
            public void applyUpgrade(TileSanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<TileSanguinaryEnvironmentalAccumulator, MutableInt>(1.0){

            @Override
            public void applyUpgrade(TileSanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, FluidStack, WeatherType>, Optional<RecipeEnvironmentalAccumulator>>(){

            public Optional<RecipeEnvironmentalAccumulator> getNewValue(Triple<ItemStack, FluidStack, WeatherType> key) {
                Inventory recipeInput = new Inventory(1, 64, TileSanguinaryEnvironmentalAccumulator.this);
                recipeInput.func_70299_a(0, (ItemStack)key.getLeft());
                return CraftingHelpers.findServerRecipe(TileSanguinaryEnvironmentalAccumulator.this.getRegistry(), (IInventory)recipeInput, (World)TileSanguinaryEnvironmentalAccumulator.this.func_145831_w());
            }

            public boolean isKeyEqual(Triple<ItemStack, FluidStack, WeatherType> cacheKey, Triple<ItemStack, FluidStack, WeatherType> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getMiddle()), (FluidStack)((FluidStack)newKey.getMiddle())) && cacheKey.getRight() == newKey.getRight();
            }
        });
        this.virtualTank = new VirtualTank(this, true);
        this.forceLoadTanks = true;
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerAccumulate = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0}));
        LazyOptional itemHandlerAccumulateResult = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{1}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerAccumulateResult);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerAccumulate);
    }

    @Override
    protected void addFluidHandlerCapabilities() {
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory(inventorySize, stackSize, this){

            @Override
            public boolean func_94041_b(int slot, ItemStack itemStack) {
                if (slot == 0) {
                    return TileSanguinaryEnvironmentalAccumulator.this.getTileWorkingMetadata().canConsume(itemStack, this.getWorld());
                }
                return super.func_94041_b(slot, itemStack);
            }
        };
    }

    @Override
    public Inventory getInventory() {
        return (Inventory)super.getInventory();
    }

    public Optional<RecipeEnvironmentalAccumulator> getRecipe(ItemStack itemStack) {
        return (Optional)this.recipeCache.get((Object)new ImmutableTriple((Object)(itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l()), (Object)this.getTank().getFluid().copy(), (Object)WeatherType.getActiveWeather(this.field_145850_b)));
    }

    protected IRecipeType<RecipeEnvironmentalAccumulator> getRegistry() {
        return RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR;
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b.func_201670_d() && this.isVisuallyWorking()) {
            this.showTankBeams();
            if (this.getRequiredWorkTicks() - (float)this.getWorkTick() > 50.0f) {
                this.showAccumulatingParticles();
            }
        } else if (this.field_145850_b.func_201670_d() && !this.canWork()) {
            this.showMissingTanks();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showAccumulatingParticles() {
        TileEnvironmentalAccumulator.showAccumulatingParticles(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.5f, (float)this.func_174877_v().func_177952_p() + 0.5f, 25.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showTankBeams() {
        Random random = this.field_145850_b.field_73012_v;
        BlockPos target = this.func_174877_v();
        for (int j = 0; j < tankOffsets.length; ++j) {
            BlockPos offset = tankOffsets[j];
            BlockPos location = target.func_177971_a((Vector3i)offset);
            double x = (double)location.func_177958_n() + 0.5;
            double y = (double)location.func_177956_o() + 0.5;
            double z = (double)location.func_177952_p() + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw((BlockPos)location, (BlockPos)target);
            float rotationPitch = (float)LocationHelpers.getPitch((BlockPos)location, (BlockPos)target);
            for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 0.5;
                double particleMotionX = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * -speed;
                double particleMotionZ = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)RegistryEntries.PARTICLE_BLOOD_BUBBLE, false, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showMissingTanks() {
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            Random random = this.field_145850_b.field_73012_v;
            for (BlockPos location : this.invalidLocations) {
                double x = (double)location.func_177958_n() + 0.5;
                double y = (double)location.func_177956_o() + 0.5;
                double z = (double)location.func_177952_p() + 0.5;
                for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                    double particleX = x - 0.2 + random.nextDouble() * 0.4;
                    double particleY = y - 0.2 + random.nextDouble() * 0.4;
                    double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                    Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)ParticleTypes.field_197601_L, false, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void onStateChanged() {
        BlockState blockState = (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockSanguinaryEnvironmentalAccumulator.ON, (Comparable)Boolean.valueOf(this.isWorking()));
        this.field_145850_b.func_175656_a(this.func_174877_v(), blockState);
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        if (!this.forceLoadTanks && this.invalidLocations != null && !WorldHelpers.efficientTick((World)this.field_145850_b, (int)60, (BlockPos)this.func_174877_v())) {
            return this.invalidLocations.isEmpty();
        }
        this.forceLoadTanks = false;
        return this.getVirtualTankChildren() != null;
    }

    @Override
    protected int getWorkTicker() {
        return this.accumulateTicker;
    }

    public VirtualTank getVirtualTank() {
        return this.virtualTank;
    }

    @Override
    @Nullable
    public IFluidHandler[] getVirtualTankChildren() {
        IFluidHandler[] tanks = new IFluidHandler[tankOffsets.length];
        this.invalidLocations.clear();
        for (int i = 0; i < tankOffsets.length; ++i) {
            BlockPos offset = tankOffsets[i];
            BlockPos location = this.func_174877_v().func_177971_a((Vector3i)offset);
            IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((IBlockReader)this.func_145831_w(), (BlockPos)location, (Direction)Direction.UP, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
            boolean oneValid = false;
            if (handler != null) {
                int tankAmount = handler.getTanks();
                for (int tank = 0; tank < tankAmount; ++tank) {
                    if (handler.getFluidInTank(tank).isEmpty() || handler.getFluidInTank(tank).getFluid() != RegistryEntries.FLUID_BLOOD) continue;
                    oneValid = true;
                    break;
                }
            }
            if (!oneValid) {
                this.invalidLocations.add(location);
            }
            tanks[i] = handler;
        }
        if (!this.invalidLocations.isEmpty()) {
            return null;
        }
        return tanks;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSanguinaryEnvironmentalAccumulator(id, playerInventory, this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.evilcraft.sanguinary_environmental_accumulator");
    }

    public List<BlockPos> getInvalidLocations() {
        return this.invalidLocations;
    }

    static {
        ACCUMULATE_TICK_ACTIONS.put(Item.class, new AccumulateItemTickAction());
        TICKERS = 1;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        tankOffsets = new BlockPos[]{new BlockPos(-3, 0, -1), new BlockPos(-3, 0, 1), new BlockPos(3, 0, -1), new BlockPos(3, 0, 1), new BlockPos(-1, 0, -3), new BlockPos(-1, 0, 3), new BlockPos(1, 0, -3), new BlockPos(1, 0, 3)};
    }

    public static class Metadata
    extends TileWorking.Metadata {
        private Metadata() {
            super(2);
        }

        @Override
        public boolean canInsertItem(IInventory inventory, int slot, ItemStack itemStack) {
            return slot != this.getProduceSlot() && super.canInsertItem(inventory, slot, itemStack);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, World world) {
            RecipeEnvironmentalAccumulator.InventoryDummy recipeInput = new RecipeEnvironmentalAccumulator.InventoryDummy(itemStack);
            return world.func_199532_z().func_215371_a(RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR, (IInventory)recipeInput, world).isPresent();
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR;
        }

        public int getConsumeSlot() {
            return 0;
        }

        public int getProduceSlot() {
            return 1;
        }
    }

    public static class Inventory
    extends TileWorking.Inventory<TileSanguinaryEnvironmentalAccumulator>
    implements RecipeEnvironmentalAccumulator.Inventory {
        public Inventory(int size, int stackLimit, TileSanguinaryEnvironmentalAccumulator tile) {
            super(size, stackLimit, tile);
        }

        @Override
        public World getWorld() {
            return ((TileSanguinaryEnvironmentalAccumulator)this.tile).func_145831_w();
        }

        @Override
        public BlockPos getPos() {
            return ((TileSanguinaryEnvironmentalAccumulator)this.tile).func_174877_v();
        }
    }
}

