/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.fluid.FluidHandlerWrapper;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestal;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestalConfig;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;
import org.cyclops.evilcraft.core.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.network.packet.SanguinaryPedestalBlockReplacePacket;

public class TileSanguinaryPedestal
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    private static final int MB_RATE = 100;
    public static final int TANK_BUCKETS = 10;
    private static final int OFFSET = 2;
    private static final int OFFSET_EFFICIENCY = 4;
    private static final int ACTIONS_PER_TICK_EFFICIENCY = 5;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private final IFluidHandler bonusFluidHandler = new FluidHandlerWrapper((IFluidHandler)this.getTank()){

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (TileSanguinaryPedestal.this.hasEfficiency() && !resource.isEmpty()) {
                resource.setAmount((int)((double)resource.getAmount() * BlockSanguinaryPedestalConfig.efficiencyBoost));
            }
            return super.fill(resource, action);
        }
    };
    private RegionIterator regionIterator;

    public TileSanguinaryPedestal() {
        super(RegistryEntries.TILE_ENTITY_SANGUINARY_PEDESTAL, 0, 1, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
    }

    public IFluidHandler getBonusFluidHandler() {
        return this.bonusFluidHandler;
    }

    @Override
    protected void addItemHandlerCapabilities() {
    }

    protected void afterBlockReplace(World world, BlockPos location) {
        EvilCraft._instance.getPacketHandler().sendToAllAround((PacketBase)new SanguinaryPedestalBlockReplacePacket(location.func_177958_n(), location.func_177956_o(), location.func_177952_p()), LocationHelpers.createTargetPointFromLocation((World)world, (BlockPos)location, (int)15));
    }

    protected boolean hasEfficiency() {
        return ((BlockSanguinaryPedestal)this.func_195044_w().func_177230_c()).getTier() == 1;
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().func_201670_d()) {
            int actions;
            int n = actions = this.hasEfficiency() ? 5 : 1;
            while (!this.getTank().isFull() && actions > 0) {
                BlockPos location = this.getNextLocation();
                Block block = this.func_145831_w().func_180495_p(location).func_177230_c();
                if (block instanceof BlockBloodStain) {
                    TileHelpers.getCapability((IBlockReader)this.func_145831_w(), (BlockPos)location, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(source -> {
                        FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)this.getBonusFluidHandler(), (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                        if (!moved.isEmpty()) {
                            this.afterBlockReplace(this.func_145831_w(), location);
                        }
                    });
                }
                --actions;
            }
            if (!this.getTank().isEmpty()) {
                for (Direction direction : Direction.values()) {
                    TileHelpers.getCapability((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(direction), (Direction)direction.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                        FluidStack fluidStack;
                        if (!this.getTank().isEmpty() && handler.fill(fluidStack = new FluidStack(this.getTank().getFluid(), Math.min(100, this.getTank().getFluidAmount())), IFluidHandler.FluidAction.SIMULATE) > 0) {
                            int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                            this.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                        }
                    });
                }
            }
        }
    }

    private BlockPos getNextLocation() {
        if (this.regionIterator == null) {
            this.regionIterator = new RegionIterator(this.func_174877_v(), this.hasEfficiency() ? 4 : 2, true);
        }
        return this.regionIterator.next();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

