/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.HollowCubeDetector;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.MaximumBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.MinimumSizeValidator;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.spiritfurnace.BoxCookTickAction;

public class TileSpiritFurnace
extends TileWorking<TileSpiritFurnace, MutableDouble>
implements INamedContainerProvider {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int[] SLOTS_DROP = new int[]{2, 3, 4, 5};
    public static final int SLOTS = 2 + SLOTS_DROP.length;
    public static Metadata METADATA = new Metadata();
    public static final int LIQUID_PER_SLOT = 10000;
    protected static final MinimumSizeValidator minimumSizeValidator = new MinimumSizeValidator(new Vector3i(2, 2, 2));
    private static CubeDetector detector;
    private static final Map<Class<?>, ITickAction<TileSpiritFurnace>> BOX_COOK_TICK_ACTIONS;
    private static final Map<Class<?>, ITickAction<TileSpiritFurnace>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    @NBTPersist(useDefaultValue=false)
    private Vector3i size = LocationHelpers.copyLocation((Vector3i)Vector3i.field_177959_e);
    @NBTPersist
    private Boolean forceHalt = false;
    @NBTPersist
    private Boolean caughtError = false;
    private int cookTicker = this.addTicker(new TickComponent<TileSpiritFurnace, ITickAction<TileSpiritFurnace>>(this, BOX_COOK_TICK_ACTIONS, 1, true, false));
    private Entity boxEntityCache = null;

    public TileSpiritFurnace() {
        super(RegistryEntries.TILE_ENTITY_SPIRIT_FURNACE, SLOTS, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.addTicker(new TickComponent<TileSpiritFurnace, ITickAction<TileSpiritFurnace>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<TileSpiritFurnace, MutableDouble>(1.0){

            @Override
            public void applyUpgrade(TileSpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSpiritFurnace, MutableDouble>(2.0){

            @Override
            public void applyUpgrade(TileSpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    public static CubeDetector getCubeDetector() {
        if (detector == null) {
            detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)RegistryEntries.BLOCK_DARK_BLOOD_BRICK), new AllowedBlock((Block)RegistryEntries.BLOCK_SPIRIT_FURNACE).addCountValidator((IBlockCountValidator)new MaximumBlockCountValidator(1))}, (List)Lists.newArrayList((Object[])new Block[]{RegistryEntries.BLOCK_SPIRIT_FURNACE, RegistryEntries.BLOCK_DARK_BLOOD_BRICK})).addSizeValidator((ISizeValidator)minimumSizeValidator);
        }
        return detector;
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerBox = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), SLOTS_DROP));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{1, 0}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerBox);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerBox);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new TileWorking.Inventory<TileSpiritFurnace>(inventorySize, stackSize, this){

            @Override
            public boolean func_94041_b(int slot, ItemStack itemStack) {
                if (slot == 1) {
                    return TileSpiritFurnace.this.getTileWorkingMetadata().canConsume(itemStack, TileSpiritFurnace.this.func_145831_w());
                }
                if (slot == 0) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)RegistryEntries.FLUID_BLOOD);
                }
                return super.func_94041_b(slot, itemStack);
            }

            public boolean func_180462_a(int slot, ItemStack itemStack, Direction side) {
                return slot < 2 && super.func_180462_a(slot, itemStack, side);
            }

            public boolean func_180461_b(int slot, ItemStack itemStack, Direction side) {
                return slot >= 2 && super.func_180461_b(slot, itemStack, side);
            }
        };
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.cookTicker;
    }

    public Entity getEntity() {
        EntityType<?> id;
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (!boxStack.func_190926_b() && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem() && (id = BlockBoxOfEternalClosure.getSpiritTypeWithFallbackSpirit(boxStack)) != null && id != RegistryEntries.ENTITY_VENGEANCE_SPIRIT) {
            Entity entity;
            if (this.boxEntityCache != null && id == this.boxEntityCache.func_200600_R()) {
                return this.boxEntityCache;
            }
            this.boxEntityCache = entity = id.func_200721_a(this.field_145850_b);
            return entity;
        }
        return null;
    }

    public String getPlayerId() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (!boxStack.func_190926_b() && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem()) {
            return BlockBoxOfEternalClosure.getPlayerId(boxStack);
        }
        return "";
    }

    public String getPlayerName() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (!boxStack.func_190926_b() && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem()) {
            return BlockBoxOfEternalClosure.getPlayerName(boxStack);
        }
        return "";
    }

    public boolean isPlayer() {
        return !this.getPlayerId().isEmpty();
    }

    public Vector3i getEntitySize() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return Vector3i.field_177959_e;
        }
        return EntityHelpers.getEntitySize((Entity)entity);
    }

    public boolean isSizeValidForEntity() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        Vector3i requiredSize = this.getEntitySize();
        return this.getInnerSize().compareTo(requiredSize) >= 0;
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        Vector3i size = this.getSize();
        return size.compareTo(minimumSizeValidator.getMinimumSize()) >= 0;
    }

    public static boolean canWork(World world, BlockPos location) {
        TileEntity tile = world.func_175625_s(location);
        if (tile != null) {
            return ((TileSpiritFurnace)tile).canWork();
        }
        return false;
    }

    public static Item getAllowedCookItem() {
        return RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE;
    }

    public static void detectStructure(IWorldReader world, BlockPos location, Vector3i size, boolean valid, BlockPos originCorner) {
    }

    public int getConsumeSlot() {
        return 1;
    }

    public int[] getProduceSlots() {
        return SLOTS_DROP;
    }

    public Vector3i getSize() {
        return this.size;
    }

    public Vector3i getInnerSize() {
        return LocationHelpers.subtract((Vector3i)this.getSize(), (Vector3i)new Vector3i(1, 1, 1));
    }

    public void setSize(Vector3i size) {
        this.size = size;
        this.sendUpdate();
    }

    public void onItemDrop(ItemStack itemStack) {
        boolean placed = false;
        int[] slots = this.getProduceSlots();
        for (int i = 0; !placed && i < slots.length; ++i) {
            ItemStack produceStack = this.getInventory().func_70301_a(slots[i]);
            if (produceStack.func_190926_b()) {
                this.getInventory().func_70299_a(slots[i], itemStack);
                placed = true;
                continue;
            }
            if (produceStack.func_77973_b() != itemStack.func_77973_b() || produceStack.func_77976_d() < produceStack.func_190916_E() + itemStack.func_190916_E()) continue;
            produceStack.func_190917_f(itemStack.func_190916_E());
            placed = true;
        }
        this.forceHalt = !placed;
    }

    @Override
    public void resetWork(boolean hardReset) {
        this.forceHalt = false;
        this.caughtError = false;
        super.resetWork(hardReset);
    }

    public boolean isForceHalt() {
        return this.forceHalt;
    }

    public boolean isCaughtError() {
        return this.caughtError;
    }

    public void caughtError() {
        this.caughtError = true;
    }

    protected Direction transformFacingForRotation(Direction facing) {
        return facing;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSpiritFurnace(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.evilcraft.spirit_furnace");
    }

    static {
        BOX_COOK_TICK_ACTIONS = new LinkedHashMap();
        BOX_COOK_TICK_ACTIONS.put(BlockBoxOfEternalClosure.class, new BoxCookTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }

    public static class Metadata
    extends TileWorking.Metadata {
        private Metadata() {
            super(SLOTS);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, World world) {
            return !itemStack.func_190926_b() && TileSpiritFurnace.getAllowedCookItem() == itemStack.func_77973_b();
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_SPIRIT_FURNACE;
        }
    }
}

