/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.block.BlockSpiritReanimator;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.spiritreanimator.ReanimateTickAction;

public class TileSpiritReanimator
extends TileWorking<TileSpiritReanimator, MutableDouble>
implements INamedContainerProvider {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int SLOT_EGG = 2;
    public static final int SLOTS_OUTPUT = 3;
    public static final int SLOTS = 4;
    public static Metadata METADATA = new Metadata();
    public static final int LIQUID_PER_SLOT = 10000;
    private static final Map<Class<?>, ITickAction<TileSpiritReanimator>> REANIMATE_COOK_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileSpiritReanimator>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private int reanimateTicker = this.addTicker(new TickComponent<TileSpiritReanimator, ITickAction<TileSpiritReanimator>>(this, REANIMATE_COOK_TICK_ACTIONS, 1, true, false));
    @NBTPersist
    private Boolean caughtError = false;

    public TileSpiritReanimator() {
        super(RegistryEntries.TILE_ENTITY_SPIRIT_REANIMATOR, 4, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.addTicker(new TickComponent<TileSpiritReanimator, ITickAction<TileSpiritReanimator>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<TileSpiritReanimator, MutableDouble>(1.0){

            @Override
            public void applyUpgrade(TileSpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSpiritReanimator, MutableDouble>(2.0){

            @Override
            public void applyUpgrade(TileSpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerInput = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{2}));
        LazyOptional itemHandlerOutput = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{3}));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0, 1}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerInput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerOutput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new TileWorking.Inventory<TileSpiritReanimator>(inventorySize, stackSize, this){

            @Override
            public boolean func_94041_b(int slot, ItemStack itemStack) {
                if (slot == 1) {
                    return TileSpiritReanimator.this.getTileWorkingMetadata().canConsume(itemStack, TileSpiritReanimator.this.func_145831_w());
                }
                if (slot == 2) {
                    return itemStack.func_77973_b() == Items.field_151110_aK;
                }
                if (slot == 0) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)RegistryEntries.FLUID_BLOOD);
                }
                return super.func_94041_b(slot, itemStack);
            }
        };
    }

    public Direction getRotation() {
        return ((Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()), (Property)BlockSpiritReanimator.FACING, (Comparable)Direction.NORTH)).func_176734_d();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.reanimateTicker;
    }

    @Nullable
    public EntityType<?> getEntityType() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack.func_77973_b() == TileSpiritReanimator.getAllowedCookItem()) {
            return BlockBoxOfEternalClosure.getSpiritTypeRaw(boxStack.func_77978_p());
        }
        return null;
    }

    public static Item getAllowedCookItem() {
        return RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE;
    }

    public int getConsumeSlot() {
        return 1;
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        ItemStack eggStack = this.getInventory().func_70301_a(2);
        ItemStack outputStack = this.getInventory().func_70301_a(3);
        EntityType<?> entityType = this.getEntityType();
        boolean validNameStack = entityType != null && (outputStack.func_190926_b() || outputStack.func_77976_d() > outputStack.func_190916_E() && SpawnEggItem.field_195987_b.get(entityType) == outputStack.func_77973_b());
        return !eggStack.func_190926_b() && validNameStack;
    }

    @Override
    public void onStateChanged() {
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockSpiritReanimator.ON, (Comparable)Boolean.valueOf(this.isWorking())));
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSpiritReanimator(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.evilcraft.spirit_reanimator");
    }

    static {
        REANIMATE_COOK_TICK_ACTIONS.put(BlockBoxOfEternalClosure.class, new ReanimateTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }

    private static class Metadata
    extends TileWorking.Metadata {
        private Metadata() {
            super(4);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, World world) {
            return !itemStack.func_190926_b() && TileSpiritReanimator.getAllowedCookItem() == itemStack.func_77973_b();
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_SPIRIT_REANIMATOR;
        }
    }
}

