/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.bloodchest;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.block.BlockColossalBloodChestConfig;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileColossalBloodChest;

public class BulkRepairItemTickAction
implements ITickAction<TileColossalBloodChest> {
    @Override
    public boolean canTick(TileColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        return tile.canWork() && !tile.getTank().isEmpty() && !itemStack.func_190926_b();
    }

    private void drainTank(TileColossalBloodChest tile, float usageMultiplier, int tick) {
        tile.getTank().drain(this.getRequiredFluid(tile, usageMultiplier, tick), IFluidHandler.FluidAction.EXECUTE);
    }

    protected int getRequiredFluid(TileColossalBloodChest tile, float usageMultiplier, int tick) {
        MutableFloat drain = new MutableFloat((Number)Math.max(0.05, (double)((float)BlockColossalBloodChestConfig.baseMBPerDamage * usageMultiplier * (1.0f - (float)tile.getEfficiency().intValue() / 210.0f))));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(drain, TileColossalBloodChest.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue().floatValue(), (int)tile.func_145831_w().func_82737_E() + tick % 100);
    }

    @Override
    public void onTick(TileColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick) && !tile.getTank().isEmpty() && !itemStack.func_190926_b()) {
            itemStack = itemStack.func_77946_l();
            IBloodChestRepairActionRegistry actions = (IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class);
            int actionID = actions.canRepair(itemStack, tick);
            if (actionID > -1) {
                float simulateMultiplier = ((Float)actions.repair(itemStack, tile.func_145831_w().field_73012_v, actionID, false, true).getLeft()).floatValue();
                if ((float)tile.getTank().getFluidAmount() >= (float)this.getRequiredFluid(tile, simulateMultiplier, tick) * simulateMultiplier) {
                    Boolean slotHistory = tile.getSlotTickHistory().get(slot);
                    if (slotHistory == null || !slotHistory.booleanValue()) {
                        tile.setEfficiency(Math.min(tile.getEfficiency() + 1, 200));
                        tile.getSlotTickHistory().put(slot, true);
                    }
                    Pair<Float, ItemStack> repairResult = actions.repair(itemStack, tile.func_145831_w().field_73012_v, actionID, true, true);
                    itemStack = (ItemStack)repairResult.getRight();
                    this.drainTank(tile, ((Float)repairResult.getLeft()).floatValue(), tick);
                }
            }
            tile.getInventory().func_70299_a(slot, itemStack);
        }
    }

    @Override
    public float getRequiredTicks(TileColossalBloodChest tile, int slot, int tick) {
        MutableFloat duration = new MutableFloat((float)BlockColossalBloodChestConfig.ticksPerDamage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(duration, TileColossalBloodChest.UPGRADEEVENT_SPEED));
        return duration.getValue().floatValue();
    }
}

