/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.bloodchest;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.block.BlockBloodChestConfig;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.tileentity.TileBloodChest;

public class RepairItemTickAction
implements ITickAction<TileBloodChest> {
    @Override
    public boolean canTick(TileBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.getTank().isEmpty() && !itemStack.func_190926_b()) {
            IBloodChestRepairActionRegistry actions = (IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class);
            int actionID = actions.canRepair(itemStack, tick);
            return actionID >= 0;
        }
        return false;
    }

    private void drainTank(TileBloodChest tile, float usageMultiplier) {
        tile.getTank().drain((int)Math.ceil((float)BlockBloodChestConfig.mBPerDamage * usageMultiplier), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void onTick(TileBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick) && !tile.getTank().isEmpty() && !itemStack.func_190926_b()) {
            itemStack = itemStack.func_77946_l();
            IBloodChestRepairActionRegistry actions = (IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class);
            int actionID = actions.canRepair(itemStack, tick);
            if (actionID > -1) {
                float simulateMultiplier = ((Float)actions.repair(itemStack, tile.func_145831_w().field_73012_v, actionID, false, false).getLeft()).floatValue();
                if ((float)tile.getTank().getFluidAmount() >= (float)BlockBloodChestConfig.mBPerDamage * simulateMultiplier) {
                    Pair<Float, ItemStack> repairResult = actions.repair(itemStack, tile.func_145831_w().field_73012_v, actionID, true, false);
                    itemStack = (ItemStack)repairResult.getRight();
                    this.drainTank(tile, ((Float)repairResult.getLeft()).floatValue());
                }
            }
            tile.getInventory().func_70299_a(slot, itemStack);
        }
    }

    @Override
    public float getRequiredTicks(TileBloodChest tile, int slot, int tick) {
        return BlockBloodChestConfig.ticksPerDamage;
    }
}

