/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileBloodInfuser;
import org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser.BloodInfuserTickAction;

public class InfuseItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && tile.getTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, this.getRecipe(tile));
    }

    @Override
    public void onTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        Optional<RecipeBloodInfuser> recipe = this.getRecipe(tile);
        if (tick >= this.getRequiredTicks(tile, recipe) && recipe.isPresent() && this.addToProduceSlot(tile, recipe.get().getOutputItem().func_77946_l())) {
            tile.getInventory().func_70298_a(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            tile.getTank().drain(this.getRequiredFluidAmount(tile, recipe), IFluidHandler.FluidAction.EXECUTE);
            tile.addXp(recipe.get().getXp());
        }
    }

    protected int getRequiredFluidAmount(TileBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        if (!recipe.isPresent()) {
            return Integer.MAX_VALUE;
        }
        MutableInt amount = new MutableInt(recipe.get().getInputFluid().getAmount());
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, TileBloodInfuser.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private Optional<RecipeBloodInfuser> getRecipe(TileBloodInfuser tile) {
        return tile.getRecipe(this.getInfuseStack(tile));
    }

    @Override
    public int getUnmodifiedRequiredTicks(TileBloodInfuser tile, int slot) {
        return this.getUnmodifiedRequiredTicks(tile, this.getRecipe(tile));
    }

    private int getUnmodifiedRequiredTicks(TileBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        return recipe.map(RecipeBloodInfuser::getDuration).orElse(0);
    }

    private int getRequiredTicks(TileBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileBloodInfuser.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    @Override
    public ItemStack willProduceItem(TileBloodInfuser tile) {
        return this.getRecipe(tile).map(recipe -> recipe.getOutputItem().func_77946_l()).orElse(ItemStack.field_190927_a);
    }
}

