/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.purifier;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.tileentity.TilePurifier;

public class CollectPotionPurifyAction
implements IPurifierAction {
    public static final Item ALLOWED_ITEM = Items.field_151069_bo;
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77973_b() == ALLOWED_ITEM;
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        if (tile.getPurifyItem().func_190926_b() && !tile.getAdditionalItem().func_190926_b() && tile.getAdditionalItem().func_77973_b() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.func_145831_w().func_217357_a(LivingEntity.class, new AxisAlignedBB(tile.func_174877_v(), tile.func_174877_v().func_177982_a(1, 2, 1)));
            for (LivingEntity entity : entities) {
                for (EffectInstance potionEffect : entity.func_70651_bq()) {
                    if (potionEffect.func_82720_e()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        if (tile.getPurifyItem().func_190926_b() && !tile.getAdditionalItem().func_190926_b() && tile.getAdditionalItem().func_77973_b() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.func_145831_w().func_217357_a(LivingEntity.class, new AxisAlignedBB(tile.func_174877_v(), tile.func_174877_v().func_177982_a(1, 2, 1)));
            for (LivingEntity entity : entities) {
                if (entity.func_70651_bq().isEmpty()) continue;
                if (tick >= 60 && !world.func_201670_d()) {
                    for (EffectInstance potionEffect : entity.func_70651_bq()) {
                        if (potionEffect.func_82720_e()) continue;
                        entity.func_195063_d(potionEffect.func_188419_a());
                        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151068_bn);
                        CompoundNBT tag = new CompoundNBT();
                        ListNBT tagList = new ListNBT();
                        CompoundNBT potionTag = new CompoundNBT();
                        itemStack.func_77982_d(tag);
                        potionEffect.func_82719_a(potionTag);
                        tagList.add((Object)potionTag);
                        tag.func_218657_a("CustomPotionEffects", (INBT)tagList);
                        tile.setBuckets(0, 0);
                        tile.setAdditionalItem(itemStack);
                        return true;
                    }
                }
                if (!world.func_201670_d()) continue;
                tile.showEffect();
            }
        }
        return false;
    }
}

