/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.purifier;

import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.enchantment.EnchantmentVengeance;
import org.cyclops.evilcraft.item.ItemVengeancePickaxe;
import org.cyclops.evilcraft.tileentity.TilePurifier;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.DamageableItemRepairAction;

public class ToolBadEnchantPurifyAction
implements IPurifierAction {
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        if (!tile.getPurifyItem().func_190926_b() && tile.getBucketsFloored() > 0) {
            for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)tile.getPurifyItem()).entrySet()) {
                if (!((Enchantment)entry.getKey()).func_190936_d()) continue;
                return true;
            }
            for (Enchantment enchant : DamageableItemRepairAction.BAD_ENCHANTS) {
                int enchantmentListID;
                if (tile.getPurifyItem().func_77973_b() instanceof ItemVengeancePickaxe && !(enchant instanceof EnchantmentVengeance) || (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)tile.getPurifyItem(), (Enchantment)enchant)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean removeEnchant(World world, TilePurifier tile, ItemStack purifyItem, int tick, Enchantment enchant) {
        int enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)purifyItem, (Enchantment)enchant);
        if (enchantmentListID > -1) {
            if (tick >= 60) {
                if (!world.func_201670_d()) {
                    int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID);
                    EnchantmentHelpers.setEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID, (int)(level - 1));
                }
                tile.setBuckets(tile.getBucketsFloored() - 1, tile.getBucketsRest());
                return true;
            }
            if (world.func_201670_d()) {
                tile.showEffect();
            }
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem();
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)tile.getPurifyItem()).entrySet()) {
            if (done || !((Enchantment)entry.getKey()).func_190936_d()) continue;
            done = this.removeEnchant(world, tile, purifyItem, tick, (Enchantment)entry.getKey());
        }
        for (Enchantment enchant : DamageableItemRepairAction.BAD_ENCHANTS) {
            if (done || tile.getPurifyItem().func_77973_b() instanceof ItemVengeancePickaxe && !(enchant instanceof EnchantmentVengeance)) continue;
            done = this.removeEnchant(world, tile, purifyItem, tick, enchant);
        }
        return done;
    }
}

