/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.block.BlockSanguinaryEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileSanguinaryEnvironmentalAccumulator;

public class AccumulateItemTickAction
implements ITickAction<TileSanguinaryEnvironmentalAccumulator> {
    @Override
    public boolean canTick(TileSanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.getInventory().func_70301_a(0).func_190926_b() && tile.getTileWorkingMetadata().canConsume(tile.getInventory().func_70301_a(0), tile.func_145831_w())) {
            ItemStack production = tile.getInventory().func_70301_a(tile.getTileWorkingMetadata().getProduceSlot());
            return this.getRecipe(tile).map(recipe -> {
                boolean precondition = false;
                ItemStack willProduce = this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe);
                if (production.func_190926_b()) {
                    precondition = true;
                } else if (!willProduce.func_190926_b() && production.func_77973_b() == this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe).func_77973_b() && Objects.equals(production.func_77978_p(), this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe).func_77978_p()) && production.func_190916_E() + willProduce.func_190916_E() <= production.func_77976_d()) {
                    precondition = true;
                }
                return precondition && tile.canWork() && tile.getVirtualTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, (RecipeEnvironmentalAccumulator)recipe);
            }).orElse(false);
        }
        return false;
    }

    @Override
    public void onTick(TileSanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        RecipeEnvironmentalAccumulator recipe;
        ItemStack result;
        Optional<RecipeEnvironmentalAccumulator> optionalRecipe = this.getRecipe(tile);
        if (optionalRecipe.isPresent() && tick >= this.getRequiredTicks(tile, optionalRecipe.get()) && this.addToProduceSlot(tile, result = (recipe = optionalRecipe.get()).getCraftingResult(tile.getInventory()))) {
            tile.getInventory().func_70298_a(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            tile.getVirtualTank().drain(this.getRequiredFluidAmount(tile, recipe), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public final float getRequiredTicks(TileSanguinaryEnvironmentalAccumulator tile, int slot, int tick) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(this.getRecipe(tile).get()));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileSanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue().intValue();
    }

    public static int getUsage(int baseCooldownTime) {
        return baseCooldownTime * BlockSanguinaryEnvironmentalAccumulatorConfig.baseUsage;
    }

    protected int getRequiredFluidAmount(TileSanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        MutableInt amount = new MutableInt(AccumulateItemTickAction.getUsage(recipe.getCooldownTime()));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, TileSanguinaryEnvironmentalAccumulator.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private Optional<RecipeEnvironmentalAccumulator> getRecipe(TileSanguinaryEnvironmentalAccumulator tile) {
        return tile.getRecipe(tile.getInventory().func_70301_a(0));
    }

    private int getUnmodifiedRequiredTicks(RecipeEnvironmentalAccumulator recipe) {
        return recipe.getDuration();
    }

    private int getRequiredTicks(TileSanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileSanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    protected ItemStack willProduceItem(TileSanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        return recipe.getCraftingResult(tile.getInventory());
    }

    public boolean addToProduceSlot(TileSanguinaryEnvironmentalAccumulator tile, ItemStack itemStack) {
        return InventoryHelpers.addToSlot((IInventory)tile.getInventory(), (int)tile.getTileWorkingMetadata().getProduceSlot(), (ItemStack)itemStack);
    }
}

