/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.spiritfurnace;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.item.WeightedItemStack;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockSpiritFurnaceConfig;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileSpiritFurnace;

public class BoxCookTickAction
implements ITickAction<TileSpiritFurnace> {
    public static final Map<Class<? extends LivingEntity>, List<WeightedItemStack>> MOBDROP_OVERRIDES = Maps.newHashMap();
    public static final Map<UUID, List<WeightedItemStack>> PLAYERDROP_OVERRIDES_INNER = Maps.newHashMap();
    public static final ItemStack[] PLAYERDROP_RANDOM;

    public static void overrideMobDrop(Class<? extends LivingEntity> entity, Set<WeightedItemStack> drops) {
        MOBDROP_OVERRIDES.put(entity, WeightedItemStack.createWeightedList(drops));
    }

    public static void overridePlayerDropInner(String playerId, ItemStack drop) {
        PLAYERDROP_OVERRIDES_INNER.put(UUID.fromString(playerId), WeightedItemStack.createWeightedList((Set)Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(drop, 1)})));
    }

    @Override
    public boolean canTick(TileSpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.isForceHalt() && !tile.isCaughtError() && tile.canWork() && tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, 0) && !this.getCookStack(tile).func_190926_b() && tile.getTileWorkingMetadata().canConsume(this.getCookStack(tile), tile.func_145831_w())) {
            for (int slotId : tile.getProduceSlots()) {
                ItemStack production = tile.getInventory().func_70301_a(slotId);
                if (production != null && production.func_190916_E() >= production.func_77976_d()) continue;
                return tile.isSizeValidForEntity();
            }
        }
        return false;
    }

    protected ItemStack getCookStack(TileSpiritFurnace tile) {
        return tile.getInventory().func_70301_a(tile.getConsumeSlot());
    }

    protected ItemStack getPlayerSkull(String playerName) {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196184_dx);
        itemStack.func_77982_d(new CompoundNBT());
        itemStack.func_77978_p().func_74778_a("SkullOwner", playerName);
        return itemStack;
    }

    protected ItemStack getPlayerDeterminedDrop(String playerId) {
        return PLAYERDROP_RANDOM[Math.abs(playerId.hashCode() % PLAYERDROP_RANDOM.length)].func_77946_l();
    }

    protected void doNextDrop(TileSpiritFurnace tile) {
        Entity entityRaw = tile.getEntity();
        if (entityRaw instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityRaw;
            World world = tile.func_145831_w();
            SoundEvent deathSound = entity.func_184615_bR();
            if (BlockSpiritFurnaceConfig.mobDeathSounds && deathSound != null) {
                BlockPos pos = tile.func_174877_v();
                world.func_184133_a(null, pos, deathSound, entity.func_184176_by(), 0.5f + world.field_73012_v.nextFloat() * 0.2f, 1.0f);
            }
            if (tile.isPlayer()) {
                WeightedItemStack weightedItemStack;
                ItemStack drop;
                UUID playerUuid = UUID.fromString(tile.getPlayerId());
                LinkedList possibleDrops = Lists.newLinkedList();
                possibleDrops.add(new WeightedItemStack(this.getPlayerDeterminedDrop(tile.getPlayerId()), 1));
                List<WeightedItemStack> overridenDrops = PLAYERDROP_OVERRIDES_INNER.get(playerUuid);
                if (overridenDrops == null) {
                    Map<String, List<WeightedItemStack>> playerDropOverrides = this.getPlayerDropOverrides();
                    overridenDrops = playerDropOverrides.get(playerUuid.toString());
                }
                if (overridenDrops != null) {
                    possibleDrops.addAll(overridenDrops);
                }
                if (!"Forgotten Player".equals(tile.getPlayerName())) {
                    possibleDrops.add(new WeightedItemStack(this.getPlayerSkull(tile.getPlayerName()), 1));
                }
                if (!(drop = (weightedItemStack = WeightedItemStack.getRandomWeightedItemStack((List)possibleDrops, (Random)world.field_73012_v)).getItemStackWithRandomizedSize(world.field_73012_v)).func_190926_b()) {
                    tile.onItemDrop(drop);
                }
            } else if (MOBDROP_OVERRIDES.containsKey(entity.getClass())) {
                List<WeightedItemStack> possibleDrops = MOBDROP_OVERRIDES.get(entity.getClass());
                WeightedItemStack weightedItemStack = WeightedItemStack.getRandomWeightedItemStack(possibleDrops, (Random)world.field_73012_v);
                ItemStack drop = weightedItemStack.getItemStackWithRandomizedSize(world.field_73012_v);
                if (!drop.func_190926_b()) {
                    tile.onItemDrop(drop);
                }
            } else {
                Map<EntityType<?>, ResourceLocation> mobDropTablesOverrides = this.getMobDropTablesOverrides();
                ResourceLocation deathLootTable = mobDropTablesOverrides.containsKey(entity.func_200600_R()) ? mobDropTablesOverrides.get(entity.func_200600_R()) : entity.func_213346_cF();
                if (deathLootTable != null) {
                    LootTable loottable = ServerLifecycleHooks.getCurrentServer().func_200249_aQ().func_186521_a(deathLootTable);
                    FakePlayer killerEntity = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)tile.func_145831_w()));
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)tile.func_145831_w()).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p())).func_216015_a(LootParameters.field_216284_d, (Object)killerEntity).func_216015_a(LootParameters.field_216285_e, (Object)killerEntity).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76377_j);
                    for (ItemStack itemstack : loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d))) {
                        tile.onItemDrop(itemstack);
                    }
                }
            }
        }
    }

    private Map<String, List<WeightedItemStack>> getPlayerDropOverrides() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String line : BlockSpiritFurnaceConfig.playerDrops) {
            String[] split = line.split("\\|");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Spirit Furnace player drop config.");
            }
            try {
                String playerId = split[0];
                boolean validId = true;
                try {
                    UUID.fromString(playerId);
                }
                catch (IllegalArgumentException e) {
                    validId = false;
                }
                if (!validId) {
                    EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " does not refer to a valid player UUID; skipping.");
                    continue;
                }
                try {
                    ItemStack itemStack = ItemStackHelpers.parseItemStack((String)split[1]);
                    map.put(playerId, Lists.newArrayList((Object[])new WeightedItemStack[]{new WeightedItemStack(itemStack, 1)}));
                }
                catch (IllegalArgumentException e) {
                    EvilCraft.clog("Invalid item '" + split[1] + "' in a Spirit Furnace player drop config; skipping:" + e.getMessage(), Level.ERROR);
                }
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " is not a number; skipping.");
            }
        }
        return map;
    }

    private Map<EntityType<?>, ResourceLocation> getMobDropTablesOverrides() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String line : BlockSpiritFurnaceConfig.mobDrops) {
            String[] split = line.split("\\|");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Spirit Furnace mob drop config.");
            }
            ResourceLocation entityName = new ResourceLocation(split[0]);
            if (!ForgeRegistries.ENTITIES.containsKey(entityName)) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace mob drop config: " + split[0] + " does not refer to a valid entity name; skipping.");
                continue;
            }
            ResourceLocation resourceLocation = new ResourceLocation(split[1]);
            map.put(ForgeRegistries.ENTITIES.getValue(entityName), resourceLocation);
        }
        return map;
    }

    protected int getRequiredMb(TileSpiritFurnace tile, int tick) {
        int baseUsage = tile.isPlayer() ? BlockSpiritFurnaceConfig.playerMBPerTick : (tile.getEntity() != null && !tile.getEntity().func_184222_aU() ? BlockSpiritFurnaceConfig.bossMBPerTick : BlockSpiritFurnaceConfig.mBPerTick);
        MutableDouble drain = new MutableDouble((double)baseUsage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritFurnace.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public void onTick(TileSpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        tile.getTank().drain(this.getRequiredMb(tile, tick), IFluidHandler.FluidAction.EXECUTE);
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            this.doNextDrop(tile);
        }
    }

    @Override
    public float getRequiredTicks(TileSpiritFurnace tile, int slot, int tick) {
        int requiredTicksBase;
        Entity entity = tile.getEntity();
        if (entity == null) {
            requiredTicksBase = BlockSpiritFurnaceConfig.requiredTicksPerHp;
        } else {
            try {
                LivingEntity livingEntity = (LivingEntity)entity;
                requiredTicksBase = (int)((livingEntity.func_110143_aJ() + (float)livingEntity.func_70658_aO()) * (float)BlockSpiritFurnaceConfig.requiredTicksPerHp);
            }
            catch (RuntimeException e) {
                requiredTicksBase = 40 * BlockSpiritFurnaceConfig.requiredTicksPerHp;
            }
        }
        MutableDouble duration = new MutableDouble((double)requiredTicksBase);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(duration, TileSpiritFurnace.UPGRADEEVENT_SPEED));
        return (int)duration.getValue().doubleValue();
    }

    static {
        if (BlockSpiritFurnaceConfig.villagerDropEmeraldChance > 0) {
            BoxCookTickAction.overrideMobDrop(VillagerEntity.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack((IItemProvider)Items.field_151166_bC), 1), new WeightedItemStack(ItemStack.field_190927_a, BlockSpiritFurnaceConfig.villagerDropEmeraldChance - 1)}));
        }
        BoxCookTickAction.overrideMobDrop(WitherEntity.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack((IItemProvider)Items.field_151156_bN), 1)}));
        BoxCookTickAction.overridePlayerDropInner("068d4de0-3a75-4c6a-9f01-8c37e16a394c", new ItemStack((IItemProvider)Items.field_151166_bC));
        BoxCookTickAction.overridePlayerDropInner("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c", new ItemStack((IItemProvider)Items.field_151041_m));
        BoxCookTickAction.overridePlayerDropInner("777e7aa3-9373-4511-8d75-f99d23ebe252", new ItemStack((IItemProvider)Items.field_222085_ly).func_200302_a((ITextComponent)new StringTextComponent("Lekkere Stront")));
        BoxCookTickAction.overridePlayerDropInner("3e13f558-fb72-4949-a842-07879924bc49", new ItemStack((IItemProvider)Items.field_151128_bU));
        BoxCookTickAction.overridePlayerDropInner("b5c31e33-8224-4f96-a4bf-73721be9d2ec", new ItemStack((IItemProvider)Blocks.field_150347_e));
        BoxCookTickAction.overridePlayerDropInner("b2faeaab-fc87-4f91-98d3-836024f268ae", new ItemStack((IItemProvider)Blocks.field_150460_al).func_200302_a((ITextComponent)new StringTextComponent("Fuurnas")));
        BoxCookTickAction.overridePlayerDropInner("069a79f4-44e9-4726-a5be-fca90e38aaf5", new ItemStack((IItemProvider)Items.field_196100_at));
        BoxCookTickAction.overridePlayerDropInner("853c80ef-3c37-49fd-aa49-938b674adae6", new ItemStack((IItemProvider)Items.field_196133_cQ).func_200302_a((ITextComponent)new StringTextComponent("jeb_")));
        BoxCookTickAction.overridePlayerDropInner("61699b2e-d327-4a01-9f1e-0ea8c3f06bc6", new ItemStack((IItemProvider)Items.field_196133_cQ).func_200302_a((ITextComponent)new StringTextComponent("Dinnerbone")));
        BoxCookTickAction.overridePlayerDropInner("bbb87dbe-690f-4205-bdc5-72ffb8ebc29d", new ItemStack((IItemProvider)Blocks.field_150347_e, 45).func_200302_a((ITextComponent)new StringTextComponent("direwolf20")));
        BoxCookTickAction.overridePlayerDropInner("0b7509f0-2458-4160-9ce1-2772b9a45ac2", new ItemStack((IItemProvider)Items.field_151147_al));
        PLAYERDROP_RANDOM = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151122_aG), new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151128_bU), new ItemStack((IItemProvider)Items.field_151023_V), new ItemStack((IItemProvider)Items.field_151071_bq), new ItemStack((IItemProvider)Items.field_151069_bo), new ItemStack((IItemProvider)Items.field_151160_bD), new ItemStack((IItemProvider)Items.field_151143_au), new ItemStack((IItemProvider)Items.field_151097_aZ), new ItemStack((IItemProvider)Items.field_222065_kN), new ItemStack((IItemProvider)Items.field_151158_bO), new ItemStack((IItemProvider)Items.field_151064_bs), new ItemStack((IItemProvider)Items.field_151141_av), new ItemStack((IItemProvider)Items.field_151060_bw), new ItemStack((IItemProvider)Items.field_151019_K), new ItemStack((IItemProvider)Items.field_151146_bM), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Blocks.field_150402_ci), new ItemStack((IItemProvider)Blocks.field_150368_y), new ItemStack((IItemProvider)Blocks.field_150425_aM), new ItemStack((IItemProvider)Blocks.field_150351_n), new ItemStack((IItemProvider)Blocks.field_150438_bZ)};
    }
}

