/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.spiritreanimator;

import net.minecraft.entity.EntityType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.block.BlockSpiritReanimatorConfig;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileSpiritReanimator;

public class ReanimateTickAction
implements ITickAction<TileSpiritReanimator> {
    @Override
    public boolean canTick(TileSpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        return tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, tick) && tile.canWork();
    }

    protected ItemStack getSpawnEgg(EntityType<?> entityType) {
        return new ItemStack((IItemProvider)SpawnEggItem.field_195987_b.get(entityType));
    }

    @Override
    public void onTick(TileSpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        tile.getTank().drain(this.getRequiredMb(tile, tick), IFluidHandler.FluidAction.EXECUTE);
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            ItemStack spawnEgg = ItemStack.field_190927_a;
            EntityType<?> entityType = tile.getEntityType();
            if (entityType != null) {
                spawnEgg = this.getSpawnEgg(entityType);
            }
            if (!spawnEgg.func_190926_b() && this.addToProduceSlot(tile, spawnEgg)) {
                tile.getInventory().func_70298_a(2, 1);
            }
            if (BlockSpiritReanimatorConfig.clearBoxContents) {
                itemStack.func_77982_d(new CompoundNBT());
                tile.getInventory().func_70299_a(1, itemStack);
            }
        }
    }

    protected int getRequiredMb(TileSpiritReanimator tile, int tick) {
        MutableDouble drain = new MutableDouble((double)BlockSpiritReanimatorConfig.mBPerTick);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritReanimator.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public float getRequiredTicks(TileSpiritReanimator tile, int slot, int tick) {
        MutableDouble drain = new MutableDouble((double)BlockSpiritReanimatorConfig.requiredTicks);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritReanimator.UPGRADEEVENT_SPEED));
        return (int)drain.getValue().doubleValue();
    }

    public boolean addToProduceSlot(TileSpiritReanimator tile, ItemStack itemStack) {
        return InventoryHelpers.addToSlot((IInventory)tile.getInventory(), (int)3, (ItemStack)itemStack);
    }
}

