/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.loot.LootTables;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.DungeonsFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.DungeonHooks;
import org.cyclops.evilcraft.RegistryEntries;

public class WorldFeatureEvilDungeon
extends DungeonsFeature {
    private static final int RADIUS_X = 3;
    private static final int RADIUS_X_RAND = 4;
    private static final int RADIUS_Z = 3;
    private static final int RADIUS_Z_RAND = 4;
    private static final int CHESTS = 2;
    private static final int CHESTS_RAND = 2;

    public WorldFeatureEvilDungeon(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos blockPos, NoFeatureConfig config) {
        BlockPos loopPos;
        int zr;
        int yr;
        int xr;
        int height = 3;
        int radiusX = random.nextInt(4) + 3;
        int radiusZ = random.nextInt(4) + 3;
        int chests = random.nextInt(2) + 2;
        int openingCounter = 0;
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
            for (yr = y - 1; yr <= y + height + 1; ++yr) {
                for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                    loopPos = new BlockPos(xr, yr, zr);
                    if (!world.func_72863_F().func_73149_a(xr / 16, yr / 16)) {
                        return false;
                    }
                    Material material = world.func_180495_p(loopPos).func_185904_a();
                    if (yr == y - 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (yr == y + height + 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (xr != x - radiusX - 1 && xr != x + radiusX + 1 && zr != z - radiusZ - 1 && zr != z + radiusZ + 1 || yr != y || !world.func_175623_d(loopPos) || !world.func_175623_d(loopPos.func_177982_a(0, 1, 0))) continue;
                    ++openingCounter;
                }
            }
        }
        if (openingCounter >= 1 && openingCounter <= 15) {
            BlockPos loopPos2;
            for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
                for (yr = y + height; yr >= y - 1; --yr) {
                    for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                        loopPos = new BlockPos(xr, yr, zr);
                        if (xr != x - radiusX - 1 && yr != y - 1 && zr != z - radiusZ - 1 && xr != x + radiusX + 1 && yr != y + height + 1 && zr != z + radiusZ + 1) {
                            world.func_217377_a(loopPos, false);
                            continue;
                        }
                        if (yr >= 0 && !world.func_180495_p(loopPos.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                            world.func_217377_a(loopPos, false);
                            continue;
                        }
                        if (!world.func_180495_p(loopPos).func_185904_a().func_76220_a()) continue;
                        if (yr == y - 1 && random.nextInt(4) != 0) {
                            world.func_180501_a(loopPos, RegistryEntries.BLOCK_BLOODY_COBBLESTONE.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(loopPos, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
            int attempts = 100;
            for (int xr2 = 0; xr2 < attempts && chests > 0; ++xr2) {
                int zrr;
                int xrr = x + random.nextInt(radiusX * 2 + 1) - radiusX;
                loopPos2 = new BlockPos(xrr, y, zrr = z + random.nextInt(radiusZ * 2 + 1) - radiusZ);
                if (!world.func_175623_d(loopPos2)) continue;
                int wallCounter = 0;
                if (world.func_180495_p(loopPos2.func_177982_a(-1, 0, 0)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_180495_p(loopPos2.func_177982_a(1, 0, 0)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_180495_p(loopPos2.func_177982_a(0, 0, -1)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_180495_p(loopPos2.func_177982_a(0, 0, 1)).func_185904_a().func_76220_a()) {
                    ++wallCounter;
                }
                if (wallCounter != 1) continue;
                world.func_180501_a(loopPos2, Blocks.field_150486_ae.func_176223_P(), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)loopPos2, (ResourceLocation)LootTables.field_186422_d);
                --chests;
            }
            for (int xs = x - 1; xs <= x + 1; xs += 2) {
                for (int zs = z - 1; zs <= z + 1; zs += 2) {
                    loopPos2 = new BlockPos(xs, y, zs);
                    world.func_180501_a(loopPos2, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tile = world.func_175625_s(loopPos2);
                    if (tile instanceof MobSpawnerTileEntity) {
                        ((MobSpawnerTileEntity)tile).func_145881_a().func_200876_a(DungeonHooks.getRandomDungeonMob((Random)random));
                        continue;
                    }
                    System.err.println("Failed to fetch mob spawner entity at (" + xs + ", " + y + ", " + zs + ")");
                }
            }
            return true;
        }
        return false;
    }
}

