/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.world.gen.structure.WorldStructureDarkTempleConfig;
import org.cyclops.evilcraft.world.gen.structure.WorldStructurePieceQuarterSymmetrical;

public class WorldStructureDarkTemple
extends Structure<NoFeatureConfig> {
    public WorldStructureDarkTemple(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    protected boolean func_230363_a_(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome biome, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        if (biome.func_201856_r() == Biome.Category.OCEAN) {
            return false;
        }
        return super.func_230363_a_(p_230363_1_, p_230363_2_, p_230363_3_, p_230363_5_, p_230363_6_, p_230363_7_, biome, p_230363_9_, (IFeatureConfig)p_230363_10_);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends WorldStructurePieceQuarterSymmetrical {
        public Piece(Random random, int x, int z) {
            super(WorldStructureDarkTempleConfig.PIECE_TYPE, random, x, 9 + WorldStructureDarkTempleConfig.darkTempleMinHeight + random.nextInt(WorldStructureDarkTempleConfig.darkTempleMaxHeight - WorldStructureDarkTempleConfig.darkTempleMinHeight), z, 9, 9, 9);
        }

        public Piece(TemplateManager templateManager, CompoundNBT tag) {
            super(WorldStructureDarkTempleConfig.PIECE_TYPE, tag);
        }

        @Override
        protected int getQuarterWidth() {
            return 6;
        }

        @Override
        protected int getQuarterHeight() {
            return 6;
        }

        @Override
        protected void generateLayers() {
            WorldStructurePieceQuarterSymmetrical.BlockWrapper us = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper((BlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper rs = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper((BlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper ds = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper((BlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cb = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_196702_dl);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper sb = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_196696_di);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cs = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_196646_bz);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper co = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_150347_e);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper wa = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_150355_j);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper fe = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_180406_aS);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper to = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_150478_aa);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cw = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_150463_bK);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper lc = new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_150486_ae.func_176223_P(), (float)GeneralConfig.darkTempleChestChance);
            lc.action = (world, pos) -> {
                Random rand = new Random();
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos, (ResourceLocation)LootTables.field_186430_l);
            };
            WorldStructurePieceQuarterSymmetrical.BlockWrapper vi = new WorldStructurePieceQuarterSymmetrical.BlockWrapper(Blocks.field_150395_bd.func_176223_P(), 0.3f);
            vi.action = (world, pos) -> {
                boolean atLeastOne = false;
                for (Direction side : Direction.Plane.HORIZONTAL) {
                    if (!world.func_180495_p(pos.func_177972_a(side)).func_224755_d((IBlockReader)world, pos.func_177972_a(side), side.func_176734_d())) continue;
                    world.func_180501_a(pos, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_196546_A.get(side), (Comparable)Boolean.valueOf(true)), 2);
                    atLeastOne = true;
                }
                if (!atLeastOne) {
                    world.func_217377_a(pos, true);
                }
            };
            WorldStructurePieceQuarterSymmetrical.BlockWrapper ea = (WorldStructurePieceQuarterSymmetrical)this.new WorldStructurePieceQuarterSymmetrical.BlockWrapper(RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR);
            Object o = null;
            this.addLayer(1, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, us, ds, vi, us, us, us, us, us, o, us, us, us, us, o, o, us, us, us, us, o, o, us, us, us, us, o, o});
            this.addLayer(2, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, vi, vi, o, o, o, o, cb, cb, vi, sb, sb, sb, sb, cb, vi, ds, co, wa, sb, o, o, co, co, co, sb, o, o, co, co, ds, sb, o, o});
            this.addLayer(3, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, lc, sb, vi, o, o, o, fe, lc, o, rs, o, o, o, o, o, cs, rs, o, o, o, o, ea, cs, rs, o, o, o});
            this.addLayer(4, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, vi, cb, vi, o, o, o, to, vi, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o});
            this.addLayer(5, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{us, o, o, o, cw, o, o, o, o, o, sb, cw, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, us});
            this.addLayer(6, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{cb, ds, rs, rs, rs, o, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, ds, o, co, co, co, co, cb});
            this.addLayer(7, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{rs, o, o, o, o, o, cw, o, o, o, o, o, cs, cs, cs, o, o, o, co, co, cs, cs, o, o, co, co, co, cs, o, o, o, co, co, cs, cw, rs});
            this.addLayer(8, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, cs, cw, o, o, o, o, o, cs, o, o, o, o});
            this.addLayer(9, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, to, o, o, o, o, o, o, o, o, o, o});
        }

        @Override
        protected void postBuildCorner(IWorld world, BlockPos blockPos, int incX, int incZ) {
            world.func_180501_a(blockPos.func_177982_a(3 * incX, 5, 4 * incZ), (BlockState)((BlockState)((BlockState)Blocks.field_222438_lb.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)DirectionHelpers.getEnumFacingFromXSign((int)incX))).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.STRAIGHT), 2);
            world.func_180501_a(blockPos.func_177982_a(4 * incX, 5, 3 * incZ), (BlockState)((BlockState)((BlockState)Blocks.field_222438_lb.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)DirectionHelpers.getEnumFacingFromZSing((int)incZ))).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.STRAIGHT), 2);
            int xx = 4 * incX;
            int zz = 4 * incZ;
            int pillarHeight = this.getPillarHeightForCornerAt(world, blockPos, incX, incZ);
            for (int yOffset = 0; yOffset < pillarHeight; ++yOffset) {
                world.func_180501_a(blockPos.func_177982_a(xx, -yOffset, zz), Blocks.field_150347_e.func_176223_P(), 2);
            }
        }

        private int getPillarHeightForCornerAt(IWorld world, BlockPos blockPos, int incX, int incZ) {
            BlockPos loopPos = blockPos.func_177982_a(4 * incX, 0, 4 * incZ);
            int res = 0;
            while (!this.isSolidBlock(world, loopPos)) {
                loopPos = loopPos.func_177982_a(0, -1, 0);
                ++res;
            }
            return res;
        }

        private boolean isSolidBlock(IWorld world, BlockPos blockPos) {
            return this.isSolidBlock(world.func_180495_p(blockPos));
        }

        private boolean isSolidBlock(BlockState blockState) {
            Material material = blockState.func_185904_a();
            return material.func_76220_a() && material.func_76218_k();
        }
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox bounds, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, bounds, references, seed);
        }

        public void func_230364_a_(DynamicRegistries p_230364_1_, ChunkGenerator p_230364_2_, TemplateManager p_230364_3_, int chunkX, int chunkY, Biome p_230364_6_, NoFeatureConfig p_230364_7_) {
            Piece piece = new Piece((Random)this.field_214631_d, chunkX * 16, chunkY * 16);
            this.field_75075_a.add(piece);
            this.func_202500_a();
        }
    }
}

