/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.WorldStructureConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.world.gen.structure.WorldStructureDarkTemple;

public class WorldStructureDarkTempleConfig
extends WorldStructureConfig {
    @ConfigurableProperty(category="worldgeneration", comment="Minimum block height at which a dark temple can spawn.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleMinHeight = 64;
    @ConfigurableProperty(category="worldgeneration", comment="Maximum blockState height at which a dark temple can spawn.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleMaxHeight = 90;
    @ConfigurableProperty(category="worldgeneration", comment="Average distance between dark temples in chunks.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleSpacing = 40;
    @ConfigurableProperty(category="worldgeneration", comment="Minimum distance between dark temples in chunks, must be smaller than spacing.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleSeparation = 16;
    public static final IStructurePieceType PIECE_TYPE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"evilcraft:dark_temple_piece", WorldStructureDarkTemple.Piece::new);
    public static StructureFeature<?, ?> CONFIGURED_FEATURE;

    public WorldStructureDarkTempleConfig() {
        super((ModBase)EvilCraft._instance, "dark_temple", eConfig -> new WorldStructureDarkTemple((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadingEvent);
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        CONFIGURED_FEATURE = (StructureFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), this.getNamedId() + "_default"), (Object)((WorldStructureDarkTemple)((Object)this.getInstance())).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        Structure.field_236365_a_.put((Object)this.getRegistryKey().func_240901_a_().toString().toLowerCase(Locale.ROOT), this.getInstance());
        StructureSeparationSettings settings = new StructureSeparationSettings(darkTempleSpacing, darkTempleSeparation, 370458167);
        ImmutableSet.of((Object)DimensionSettings.field_242734_c, (Object)DimensionSettings.field_242735_d, (Object)DimensionSettings.field_242736_e, (Object)DimensionSettings.field_242737_f, (Object)DimensionSettings.field_242738_g, (Object)DimensionSettings.field_242739_h, (Object[])new RegistryKey[0]).stream().map(arg_0 -> ((Registry)WorldGenRegistries.field_243658_j).func_230516_a_(arg_0)).map(DimensionSettings::func_236108_a_).map(DimensionStructuresSettings::func_236195_a_).forEach(m -> m.put(this.getInstance(), settings));
    }

    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getCategory() != Biome.Category.THEEND && event.getCategory() != Biome.Category.NETHER) {
            event.getGeneration().getStructures().add(() -> CONFIGURED_FEATURE);
        }
    }
}

