/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.StructureManager;

public abstract class WorldStructurePieceQuarterSymmetrical
extends ScatteredStructurePiece {
    private final List<Integer> layerHeights = Lists.newArrayList();
    private final List<BlockWrapper[]> layers = Lists.newArrayList();

    protected WorldStructurePieceQuarterSymmetrical(IStructurePieceType structurePieceTypeIn, Random rand, int xIn, int yIn, int zIn, int widthIn, int heightIn, int depthIn) {
        super(structurePieceTypeIn, rand, xIn, yIn, zIn, widthIn, heightIn, depthIn);
        this.generateLayers();
    }

    protected WorldStructurePieceQuarterSymmetrical(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
        super(structurePieceTypeIn, nbt);
        this.generateLayers();
    }

    protected abstract int getQuarterWidth();

    protected abstract int getQuarterHeight();

    protected abstract void generateLayers();

    protected void addLayer(int height, BlockWrapper[] layer) {
        this.layerHeights.add(height);
        this.layers.add(layer);
    }

    protected void buildCorner(IWorld world, BlockPos blockPos, int incX, int incZ) {
        Random r = new Random();
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.getQuarterHeight(); ++zr) {
                for (int xr = start; xr < this.getQuarterWidth(); ++xr) {
                    BlockWrapper wrapper = layer[(this.getQuarterWidth() - xr - 1) * this.getQuarterHeight() + zr];
                    BlockPos posOffset = blockPos.func_177982_a(xr * incX, layerHeight, zr * incZ);
                    if (wrapper == null || !(wrapper.chance > 0.0f) || !(wrapper.chance >= r.nextFloat())) continue;
                    world.func_180501_a(blockPos.func_177982_a(xr * incX, layerHeight, zr * incZ), wrapper.blockState, 2);
                    if (wrapper.action == null) continue;
                    wrapper.action.run(world, posOffset);
                }
            }
        }
        this.postBuildCorner(world, blockPos, incX, incZ);
    }

    protected void postBuildCorner(IWorld world, BlockPos pos, int incX, int incZ) {
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.getQuarterHeight(); ++zr) {
                for (int xr = start; xr < this.getQuarterWidth(); ++xr) {
                    BlockWrapper wrapper = layer[(this.getQuarterWidth() - xr - 1) * this.getQuarterHeight() + zr];
                    if (wrapper == null) continue;
                    BlockPos posOffset = pos.func_177982_a(xr * incX, layerHeight, zr * incZ);
                    if (wrapper.action == null || world.func_180495_p(posOffset) != wrapper.blockState) continue;
                    wrapper.action.run(world, posOffset);
                }
            }
        }
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
        int x = rand.nextInt(16);
        int z = rand.nextInt(16);
        BlockPos blockPos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(0), this.func_74873_b(x, z));
        this.buildCorner((IWorld)world, blockPos, 1, 1);
        this.buildCorner((IWorld)world, blockPos, -1, 1);
        this.buildCorner((IWorld)world, blockPos, 1, -1);
        this.buildCorner((IWorld)world, blockPos, -1, -1);
        return true;
    }

    public static interface IBlockAction {
        public void run(IWorld var1, BlockPos var2);
    }

    public class BlockWrapper {
        public BlockState blockState;
        public float chance = 1.0f;
        public IBlockAction action = null;

        public BlockWrapper(Block block) {
            this(block.func_176223_P());
        }

        public BlockWrapper(BlockState blockState) {
            this.blockState = blockState;
        }

        public BlockWrapper(BlockState blockState, float chance) {
            this(blockState);
            this.chance = chance;
        }
    }
}

