/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.capabilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.ingredient.recipe.IngredientRecipeHelpers;
import org.cyclops.cyclopscore.ingredient.recipe.RecipeHandlerRecipeType;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.InventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.tileentity.TileBloodInfuser;
import org.cyclops.evilcraftcompat.Capabilities;

public class RecipeHandlerBloodInfuserTileCompat
extends SimpleCapabilityConstructor<IRecipeHandler, TileBloodInfuser> {
    public Capability<IRecipeHandler> getCapability() {
        return Capabilities.RECIPE_HANDLER;
    }

    @Nullable
    public ICapabilityProvider createProvider(TileBloodInfuser host) {
        return new DefaultCapabilityProvider(() -> Capabilities.RECIPE_HANDLER, (Object)new RecipeHandler(host));
    }

    public static class RecipeHandler
    extends RecipeHandlerRecipeType<IInventoryFluidTier, RecipeBloodInfuser> {
        private final TileBloodInfuser host;

        public RecipeHandler(TileBloodInfuser host) {
            super(() -> ((TileBloodInfuser)host).func_145831_w(), RegistryEntries.RECIPETYPE_BLOOD_INFUSER, (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK}), (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}));
            this.host = host;
        }

        public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
            return (component == IngredientComponent.ITEMSTACK || component == IngredientComponent.FLUIDSTACK) && size == 1;
        }

        @Nullable
        protected IInventoryFluidTier getRecipeInputContainer(IMixedIngredients input) {
            InventoryFluidTier inventory = new InventoryFluidTier((NonNullList<ItemStack>)NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a), (NonNullList<FluidStack>)NonNullList.func_191197_a((int)1, (Object)FluidStack.EMPTY), this.host.getTileWorkingMetadata().getTier((IInventory)this.host.getInventory()));
            if (!input.getInstances(IngredientComponent.ITEMSTACK).isEmpty()) {
                inventory.func_70299_a(0, (ItemStack)input.getInstances(IngredientComponent.ITEMSTACK).get(0));
            }
            if (!input.getInstances(IngredientComponent.FLUIDSTACK).isEmpty()) {
                inventory.getFluidHandler().fill((FluidStack)input.getInstances(IngredientComponent.FLUIDSTACK).get(0), IFluidHandler.FluidAction.EXECUTE);
            }
            return inventory;
        }

        @Nullable
        protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getRecipeInputIngredients(RecipeBloodInfuser recipe) {
            IdentityHashMap inputs = Maps.newIdentityHashMap();
            if (!recipe.getInputIngredient().func_203189_d()) {
                inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{IngredientRecipeHelpers.getPrototypesFromIngredient((Ingredient)recipe.getInputIngredient())}));
            }
            if (!recipe.getInputFluid().isEmpty()) {
                inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)recipe.getInputFluid(), (Object)7)}))}));
            }
            return inputs;
        }

        @Nullable
        protected IMixedIngredients getRecipeOutputIngredients(RecipeBloodInfuser recipe) {
            IdentityHashMap outputIngredients = Maps.newIdentityHashMap();
            if (!recipe.getOutputItem().func_190926_b()) {
                outputIngredients.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getOutputItem()}));
            }
            if (outputIngredients.isEmpty()) {
                return null;
            }
            return new MixedIngredients((Map)outputIngredients);
        }
    }
}

