/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei;

import java.text.DecimalFormat;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenBloodInfuser;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenExaltedCrafter;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenOriginsOfDarkness;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraftcompat.RegistryEntriesCompat;
import org.cyclops.evilcraftcompat.modcompat.jei.SubtypeInterpreterActivatableFluidContainer;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeJEI;

@JeiPlugin
public class JEIEvilCraftConfig
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        SubtypeInterpreterActivatableFluidContainer subtypeInterpreter = new SubtypeInterpreterActivatableFluidContainer();
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntries.ITEM_BLOOD_EXTRACTOR, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntries.ITEM_BLOOD_PEARL_OF_TELEPORTATION, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntries.ITEM_DARK_TANK, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntriesCompat.ITEM_INVIGORATING_PENDANT, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntriesCompat.ITEM_PRIMED_PENDANT, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntriesCompat.ITEM_KINETICATOR, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntriesCompat.ITEM_KINETICATOR_REPELLING, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter((Item)RegistryEntries.ITEM_MACE_OF_DISTORTION, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntriesCompat.ITEM_MACE_OF_DESTRUCTION, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntriesCompat.ITEM_NECROMANCER_STAFF, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntriesCompat.ITEM_FLESH_REJUVENATED, (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(RegistryEntries.ITEM_ENTANGLED_CHALICE, (ISubtypeInterpreter)subtypeInterpreter);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new BloodInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SanguinaryEnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(BloodInfuserRecipeJEI.getAllRecipes(), BloodInfuserRecipeCategory.NAME);
        registry.addRecipes(EnvironmentalAccumulatorRecipeJEI.getAllRecipes(), EnvironmentalAccumulatorRecipeCategory.NAME);
        registry.addRecipes(SanguinaryEnvironmentalAccumulatorRecipeJEI.getAllRecipes(), SanguinaryEnvironmentalAccumulatorRecipeCategory.NAME);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RegistryEntries.BLOCK_BLOOD_INFUSER), new ResourceLocation[]{BloodInfuserRecipeCategory.NAME});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR), new ResourceLocation[]{EnvironmentalAccumulatorRecipeCategory.NAME});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR), new ResourceLocation[]{SanguinaryEnvironmentalAccumulatorRecipeCategory.NAME});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RegistryEntries.ITEM_EXALTED_CRAFTER), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN_EMPOWERED), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RegistryEntries.ITEM_EXALTED_CRAFTER_EMPOWERED), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerBloodInfuser.class, BloodInfuserRecipeCategory.NAME, 1, 1, 7, 36);
        registry.addRecipeTransferHandler(ContainerSanguinaryEnvironmentalAccumulator.class, SanguinaryEnvironmentalAccumulatorRecipeCategory.NAME, 0, 1, 6, 36);
        registry.addRecipeTransferHandler(ContainerExaltedCrafter.class, VanillaRecipeCategoryUid.CRAFTING, 0, 9, 10, 63);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ContainerScreenBloodInfuser.class, 130, 36, 24, 16, new ResourceLocation[]{BloodInfuserRecipeCategory.NAME});
        registry.addRecipeClickArea(ContainerScreenSanguinaryEnvironmentalAccumulator.class, 105, 36, 24, 16, new ResourceLocation[]{SanguinaryEnvironmentalAccumulatorRecipeCategory.NAME});
        registry.addRecipeClickArea(ContainerScreenExaltedCrafter.class, 88, 32, 28, 23, new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registry.addGuiScreenHandler(ContainerScreenOriginsOfDarkness.class, screen -> null);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("evilcraftcompat", "main");
    }

    public static IFormattableTextComponent getDurationSecondsTextComponent(int durationTicks) {
        String seconds = new DecimalFormat("#.##").format((double)durationTicks / 20.0);
        return new TranslationTextComponent("gui.jei.category.smelting.time.seconds", new Object[]{seconds});
    }
}

