/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.item.ItemPromise;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeJEI;

public class BloodInfuserRecipeCategory
implements IRecipeCategory<BloodInfuserRecipeJEI> {
    public static final ResourceLocation NAME = new ResourceLocation("evilcraftcompat", "blood_infuser");
    private static final int INPUT_SLOT = 0;
    private static final int UPGRADE_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int FLUID_SLOT = 3;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public BloodInfuserRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("evilcraftcompat", "textures/gui/blood_infuser_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RegistryEntries.BLOCK_BLOOD_INFUSER));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<? extends BloodInfuserRecipeJEI> getRecipeClass() {
        return BloodInfuserRecipeJEI.class;
    }

    @Nonnull
    public String getTitle() {
        return new TranslationTextComponent(RegistryEntries.BLOCK_BLOOD_INFUSER.func_149739_a()).getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxTankSize(BloodInfuserRecipeJEI bloodInfuserRecipe) {
        return 10000 * TileWorking.getTankTierMultiplier(bloodInfuserRecipe.getInputTier());
    }

    protected ItemStack getPromise(BloodInfuserRecipeJEI bloodInfuserRecipe) {
        if (bloodInfuserRecipe.getInputTier() == 0) {
            return null;
        }
        return new ItemStack((IItemProvider)ItemPromise.getItem(bloodInfuserRecipe.getInputTier()));
    }

    public void setIngredients(BloodInfuserRecipeJEI recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputItems());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutputItem());
        ingredients.setInput(VanillaTypes.FLUID, (Object)recipe.getInputFluid());
    }

    public void setRecipe(IRecipeLayout recipeLayout, BloodInfuserRecipeJEI recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 41, 27);
        recipeLayout.getItemStacks().init(1, false, 41, 7);
        recipeLayout.getItemStacks().init(2, false, 95, 27);
        recipeLayout.getItemStacks().set(0, recipe.getInputItems());
        recipeLayout.getItemStacks().set(1, this.getPromise(recipe));
        recipeLayout.getItemStacks().set(2, recipe.getOutputItem());
        recipeLayout.getFluidStacks().init(3, true, 6, 6, 16, 58, this.getMaxTankSize(recipe), true, this.tankOverlay);
        recipeLayout.getFluidStacks().set(3, recipe.getInputFluid());
    }

    public void draw(BloodInfuserRecipeJEI recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 65, 28);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        IFormattableTextComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)duration, (float)((this.background.getWidth() - fontRenderer.func_238414_a_((ITextProperties)duration)) / 2 + 12), 50.0f, -8355712);
    }
}

