/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeJEI;

public class SanguinaryEnvironmentalAccumulatorRecipeCategory
extends CommonEnvironmentalAccumulatorRecipeCategory<SanguinaryEnvironmentalAccumulatorRecipeJEI> {
    public static final ResourceLocation NAME = new ResourceLocation("evilcraftcompat", "sanguinary_environmental_accumulator");
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int FLUID_SLOT = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public SanguinaryEnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Pair<Integer, Integer>)Pair.of((Object)42, (Object)8), (Pair<Integer, Integer>)Pair.of((Object)96, (Object)8));
        ResourceLocation resourceLocation = new ResourceLocation("evilcraftcompat", "textures/gui/sanguinary_environmental_accumulator_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<? extends SanguinaryEnvironmentalAccumulatorRecipeJEI> getRecipeClass() {
        return SanguinaryEnvironmentalAccumulatorRecipeJEI.class;
    }

    @Nonnull
    public String getTitle() {
        return new TranslationTextComponent(RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.func_149739_a()).getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SanguinaryEnvironmentalAccumulatorRecipeJEI recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputItems());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutputItem());
    }

    @Override
    public void draw(SanguinaryEnvironmentalAccumulatorRecipeJEI recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, matrixStack, mouseX, mouseY);
        this.arrow.draw(matrixStack, 65, 28);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        IFormattableTextComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)duration, (float)((this.background.getWidth() - fontRenderer.func_238414_a_((ITextProperties)duration)) / 2 + 12), 50.0f, -8355712);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, SanguinaryEnvironmentalAccumulatorRecipeJEI recipe, IIngredients ingredients) {
        super.setRecipe(recipeLayout, recipe, ingredients);
        recipeLayout.getItemStacks().init(0, true, 41, 27);
        recipeLayout.getItemStacks().init(1, false, 95, 27);
        recipeLayout.getItemStacks().set(0, recipe.getInputItems());
        recipeLayout.getItemStacks().set(1, recipe.getOutputItem());
        FluidStack fluidStack = new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, AccumulateItemTickAction.getUsage(recipe.getCooldownTime()));
        recipeLayout.getFluidStacks().init(2, true, 6, 6, 16, 58, fluidStack.getAmount(), true, this.tankOverlay);
        recipeLayout.getFluidStacks().set(2, fluidStack);
    }
}

