/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.RenderUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player;
        ItemStack stack;
        if (event.phase == TickEvent.Phase.END && ClientEventHandler.mc.field_71439_g != null && !ClientEventHandler.mc.field_71474_y.field_74319_N && !ClientEventHandler.mc.field_71474_y.field_74330_P && (ClientEventHandler.mc.field_71462_r == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && ClientEventHandler.mc.field_71462_r instanceof ChatScreen) && (stack = ItemUtils.getHeldItem((PlayerEntity)(player = ClientEventHandler.mc.field_71439_g), ExplorersCompass.explorersCompass)) != null && stack.func_77973_b() instanceof ExplorersCompassItem) {
            MatrixStack matrixStack = new MatrixStack();
            ExplorersCompassItem compass = (ExplorersCompassItem)stack.func_77973_b();
            if (compass.getState(stack) == CompassState.SEARCHING) {
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.searching", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, StructureUtils.getStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            } else if (compass.getState(stack) == CompassState.FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.found", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, StructureUtils.getStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.coordinates", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, compass.getFoundStructureX(stack) + ", " + compass.getFoundStructureZ(stack), 5, 5, 0xAAAAAA, 7);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.distance", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, String.valueOf(StructureUtils.getDistanceToStructure((PlayerEntity)player, compass.getFoundStructureX(stack), compass.getFoundStructureZ(stack))), 5, 5, 0xAAAAAA, 10);
            } else if (compass.getState(stack) == CompassState.NOT_FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.notFound", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, StructureUtils.getStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, I18n.func_135052_a((String)"string.explorerscompass.samples", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                RenderUtils.drawConfiguredStringOnHUD(matrixStack, String.valueOf(compass.getSamples(stack)), 5, 5, 0xAAAAAA, 10);
            }
        }
    }
}

