/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.StructureSearchEntry;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.gui.TransparentButton;
import com.chaosthedude.explorerscompass.gui.TransparentTextField;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.CompassSearchPacket;
import com.chaosthedude.explorerscompass.network.TeleportPacket;
import com.chaosthedude.explorerscompass.sorting.ISorting;
import com.chaosthedude.explorerscompass.sorting.NameSorting;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExplorersCompassScreen
extends Screen {
    private World world;
    private PlayerEntity player;
    private List<Structure<?>> allowedStructures;
    private List<Structure<?>> structuresMatchingSearch;
    private ItemStack stack;
    private ExplorersCompassItem explorersCompass;
    private Button startSearchButton;
    private Button sortByButton;
    private Button teleportButton;
    private Button cancelButton;
    private TransparentTextField searchTextField;
    private StructureSearchList selectionList;
    private ISorting sortingCategory;

    public ExplorersCompassScreen(World world, PlayerEntity player, ItemStack stack, ExplorersCompassItem explorersCompass, List<Structure<?>> allowedStructures) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"string.explorersCompass.selectStructure", (Object[])new Object[0])));
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.explorersCompass = explorersCompass;
        this.allowedStructures = allowedStructures;
        this.structuresMatchingSearch = new ArrayList(allowedStructures);
        this.sortingCategory = new NameSorting();
    }

    public boolean func_231043_a_(double scroll1, double scroll2, double scroll3) {
        return this.selectionList.func_231043_a_(scroll1, scroll2, scroll3);
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.setupButtons();
        this.setupTextFields();
        if (this.selectionList == null) {
            this.selectionList = new StructureSearchList(this, this.field_230706_i_, this.field_230708_k_ + 110, this.field_230709_l_, 40, this.field_230709_l_, 36);
        }
        this.field_230705_e_.add(this.selectionList);
    }

    public void func_231023_e_() {
        this.searchTextField.func_146178_a();
        this.teleportButton.field_230693_o_ = this.explorersCompass.getState(this.stack) == CompassState.FOUND;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.selectionList.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        ExplorersCompassScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"string.explorerscompass.selectStructure", (Object[])new Object[0]), (int)65, (int)15, (int)0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        boolean ret = super.func_231046_a_(par1, par2, par3);
        if (this.searchTextField.func_230999_j_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        boolean ret = super.func_231042_a_(typedChar, keyCode);
        if (this.searchTextField.func_230999_j_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void selectStructure(StructureSearchEntry entry) {
        boolean enable;
        this.startSearchButton.field_230693_o_ = enable = entry != null;
    }

    public void searchForStructure(Structure<?> structure) {
        ExplorersCompass.network.sendToServer((Object)new CompassSearchPacket(StructureUtils.getKeyForStructure(structure), this.player.func_233580_cy_()));
        this.field_230706_i_.func_147108_a(null);
    }

    public void teleport() {
        ExplorersCompass.network.sendToServer((Object)new TeleportPacket());
        this.field_230706_i_.func_147108_a(null);
    }

    public void processSearchTerm() {
        this.structuresMatchingSearch = new ArrayList();
        for (Structure<?> structure : this.allowedStructures) {
            if (!StructureUtils.getStructureName(structure).toLowerCase().contains(this.searchTextField.func_146179_b().toLowerCase())) continue;
            this.structuresMatchingSearch.add(structure);
        }
        this.selectionList.refreshList();
    }

    public List<Structure<?>> sortStructures() {
        List<Structure<?>> structures = this.structuresMatchingSearch;
        Collections.sort(structures, new NameSorting());
        Collections.sort(structures, this.sortingCategory);
        return structures;
    }

    private void setupButtons() {
        this.field_230710_m_.clear();
        this.cancelButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, this.field_230709_l_ - 30, 110, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), onPress -> this.field_230706_i_.func_147108_a(null)));
        this.startSearchButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, 40, 110, 20, (ITextComponent)new TranslationTextComponent("string.explorerscompass.startSearch"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((StructureSearchEntry)this.selectionList.func_230958_g_()).searchForBiome();
            }
        }));
        this.sortByButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, 65, 110, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"string.explorerscompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.func_238482_a_((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"string.explorerscompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()));
            this.selectionList.refreshList();
        }));
        this.teleportButton = (Button)this.func_230480_a_((Widget)new TransparentButton(this.field_230708_k_ - 120, 10, 110, 20, (ITextComponent)new TranslationTextComponent("string.explorerscompass.teleport"), onPress -> this.teleport()));
        this.startSearchButton.field_230693_o_ = false;
        this.teleportButton.field_230694_p_ = ExplorersCompass.canTeleport;
    }

    private void setupTextFields() {
        this.searchTextField = new TransparentTextField(this.field_230712_o_, this.field_230708_k_ / 2 - 82, 10, 140, 20, (ITextComponent)new TranslationTextComponent("string.explorerscompass.search"));
        this.field_230705_e_.add(this.searchTextField);
    }
}

