/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<Structure<?>> allowedStructures;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<Structure<?>> allowedStructures) {
        this.canTeleport = canTeleport;
        this.allowedStructures = allowedStructures;
    }

    public SyncPacket(PacketBuffer buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedStructures = new ArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.allowedStructures.add(StructureUtils.getStructureForKey(buf.func_192575_l()));
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedStructures.size());
        for (Structure<?> structure : this.allowedStructures) {
            buf.func_192572_a(StructureUtils.getKeyForStructure(structure));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ExplorersCompass.canTeleport = this.canTeleport;
            ExplorersCompass.allowedStructures = this.allowedStructures;
        });
        ctx.get().setPacketHandled(true);
    }
}

