/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureSearchWorker
implements WorldWorkerManager.IWorker {
    public ServerWorld world;
    public Structure<?> structure;
    public ResourceLocation structureKey;
    public BlockPos startPos;
    public int samples;
    public int nextLength;
    public Direction direction;
    public ItemStack stack;
    public PlayerEntity player;
    public int chunkX;
    public int chunkZ;
    public int length;
    public boolean finished;
    public SharedSeedRandom rand;
    public int x;
    public int z;
    public int lastRadiusThreshold;

    public StructureSearchWorker(ServerWorld world, PlayerEntity player, ItemStack stack, Structure<?> structure, BlockPos startPos) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.structure = structure;
        this.startPos = startPos;
        this.chunkX = startPos.func_177958_n() >> 4;
        this.chunkZ = startPos.func_177952_p() >> 4;
        this.x = startPos.func_177958_n();
        this.z = startPos.func_177952_p();
        this.nextLength = 1;
        this.length = 0;
        this.samples = 0;
        this.direction = Direction.UP;
        this.finished = !world.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_() || !world.func_72863_F().func_201711_g().func_202090_b().func_205004_a(structure);
        this.structureKey = ForgeRegistries.STRUCTURE_FEATURES.getKey(structure);
        this.rand = new SharedSeedRandom();
        this.lastRadiusThreshold = 0;
    }

    public void start() {
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() == ExplorersCompass.explorersCompass) {
            if ((Integer)ConfigHandler.GENERAL.maxRadius.get() > 0) {
                ExplorersCompass.LOGGER.info("Starting search: " + ConfigHandler.GENERAL.maxRadius.get() + " max radius, " + ConfigHandler.GENERAL.maxSamples.get() + " max samples");
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
            } else {
                this.finish(false);
            }
        }
    }

    public boolean hasWork() {
        return !this.finished && this.getRadius() <= (Integer)ConfigHandler.GENERAL.maxRadius.get() && this.samples <= (Integer)ConfigHandler.GENERAL.maxSamples.get();
    }

    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == Direction.NORTH) {
                --this.chunkZ;
            } else if (this.direction == Direction.EAST) {
                ++this.chunkX;
            } else if (this.direction == Direction.SOUTH) {
                ++this.chunkZ;
            } else if (this.direction == Direction.WEST) {
                --this.chunkX;
            }
            this.x = this.chunkX << 4;
            this.z = this.chunkZ << 4;
            StructureSeparationSettings separationSettings = this.world.func_72863_F().func_201711_g().func_235957_b_().func_236197_a_(this.structure);
            ChunkPos chunkPos = this.structure.func_236392_a_(separationSettings, this.world.func_72905_C(), this.rand, this.chunkX, this.chunkZ);
            IChunk chunk = this.world.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222606_b);
            StructureStart structureStart = this.world.func_241112_a_().func_235013_a_(SectionPos.func_218156_a((ChunkPos)chunk.func_76632_l(), (int)0), this.structure, (IStructureReader)chunk);
            if (structureStart != null && structureStart.func_75069_d()) {
                this.x = structureStart.func_204294_a().func_177958_n();
                this.z = structureStart.func_204294_a().func_177952_p();
                this.finish(true);
                return true;
            }
            ++this.samples;
            ++this.length;
            if (this.length >= this.nextLength) {
                if (this.direction != Direction.UP) {
                    ++this.nextLength;
                    this.direction = this.direction.func_176746_e();
                } else {
                    this.direction = Direction.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 250 && radius / 250 > this.lastRadiusThreshold) {
                ((ExplorersCompassItem)this.stack.func_77973_b()).setSearchRadius(this.stack, this.roundRadius(radius, 250), this.player);
                this.lastRadiusThreshold = radius / 250;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(false);
        return false;
    }

    private void finish(boolean found) {
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() == ExplorersCompass.explorersCompass) {
            if (found) {
                ExplorersCompass.LOGGER.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ExplorersCompassItem)this.stack.func_77973_b()).setFound(this.stack, this.x, this.z, this.samples, this.player);
            } else {
                ExplorersCompass.LOGGER.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ExplorersCompassItem)this.stack.func_77973_b()).setNotFound(this.stack, this.player, this.roundRadius(this.getRadius(), 250), this.samples);
            }
        } else {
            ExplorersCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private int getRadius() {
        return StructureUtils.getDistanceToStructure(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }
}

