/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.util.StructureSearchWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ResourceLocation getKeyForStructure(Structure<?> structure) {
        return ForgeRegistries.STRUCTURE_FEATURES.getKey(structure);
    }

    public static Structure<?> getStructureForKey(ResourceLocation key) {
        return (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(key);
    }

    public static List<Structure<?>> getAllowedStructures() {
        ArrayList structures = new ArrayList();
        for (Structure structure : ForgeRegistries.STRUCTURE_FEATURES) {
            if (structure == null || StructureUtils.getStructureForKey(structure.getRegistryName()) == null || StructureUtils.structureIsBlacklisted(structure)) continue;
            structures.add(structure);
        }
        return structures;
    }

    public static void searchForStructure(ServerWorld world, PlayerEntity player, ItemStack stack, Structure<?> structure, BlockPos startPos) {
        StructureSearchWorker worker = new StructureSearchWorker(world, player, stack, structure, startPos);
        worker.start();
    }

    public static int getDistanceToStructure(PlayerEntity player, int biomeX, int biomeZ) {
        return StructureUtils.getDistanceToStructure(player.func_233580_cy_(), biomeX, biomeZ);
    }

    public static int getDistanceToStructure(BlockPos startPos, int structureX, int structureZ) {
        return (int)MathHelper.func_76133_a((double)startPos.func_177951_i((Vector3i)new BlockPos(structureX, startPos.func_177956_o(), structureZ)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureName(Structure<?> structure) {
        String name = StructureUtils.getKeyForStructure(structure).toString();
        if (((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = I18n.func_135052_a((String)Util.func_200697_a((String)"structure", (ResourceLocation)StructureUtils.getKeyForStructure(structure)), (Object[])new Object[0]);
        }
        if (name.equals(Util.func_200697_a((String)"structure", (ResourceLocation)StructureUtils.getKeyForStructure(structure))) || !((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = StructureUtils.getKeyForStructure(structure).toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureName(ResourceLocation key) {
        return StructureUtils.getStructureName(StructureUtils.getStructureForKey(key));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureSource(Structure<?> structure) {
        if (StructureUtils.getKeyForStructure(structure) == null) {
            return "";
        }
        String registryEntry = StructureUtils.getKeyForStructure(structure).toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static boolean structureIsBlacklisted(Structure<?> structure) {
        List structureBlacklist = (List)ConfigHandler.GENERAL.structureBlacklist.get();
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getKeyForStructure(structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    private static String convertToRegex(String glob) {
        String regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? regex + ".*" : (c == '?' ? regex + "." : (c == '.' ? regex + "\\." : regex + c));
        }
        regex = regex + "$";
        return regex;
    }
}

