/*
 * Decompiled with CFR 0.152.
 */
package net.elytraautopilot;

import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.elytraautopilot.ElytraConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;

public class ElytraAutoPilot
implements ModInitializer,
ClientModInitializer {
    public ElytraConfig config;
    private static class_304 keyBinding;
    public static ElytraAutoPilot instance;
    private boolean lastPressed = false;
    private class_310 minecraftClient;
    public boolean showHud;
    private boolean autoFlight;
    private class_243 previousPosition;
    private double currentVelocity;
    public boolean isDescending;
    public boolean pullUp;
    public boolean pullDown;
    private double velHigh = 0.0;
    private double velLow = 0.0;
    private int argXpos;
    private int argZpos;
    private boolean isflytoActive = false;
    private boolean isLanding = false;
    private int _tick = 0;
    private int _index = -1;
    private List<Double> velocityList = new ArrayList<Double>();
    File configFile;
    public String[] hudString;

    public void onInitialize() {
        System.out.println("Hello Fabric world client ElytraAutoPilot.onInitialize!");
        ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"flyto").then(ClientCommandManager.argument((String)"X", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).then(ClientCommandManager.argument((String)"Z", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).executes(context -> {
            if (this.autoFlight) {
                this.argXpos = IntegerArgumentType.getInteger((CommandContext)context, (String)"X");
                this.argZpos = IntegerArgumentType.getInteger((CommandContext)context, (String)"Z");
                this.isflytoActive = true;
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585("Flying to " + this.argXpos + ", " + this.argZpos).method_27692(class_124.field_1060));
                return 1;
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585("You need to have autoflight activated to use this command").method_27692(class_124.field_1061));
            return 1;
        }))));
        keyBinding = new class_304("key.elytraautopilot.toggle", class_3675.class_307.field_1668, 82, "text.elytraautopilot.title");
        KeyBindingHelper.registerKeyBinding((class_304)keyBinding);
        this.lastPressed = false;
        System.out.println("Registering client tick");
        ClientTickEvents.END_CLIENT_TICK.register(e -> this.onTick());
        instance = this;
        Path configdir = FabricLoader.getInstance().getConfigDir();
        String moddir = "/elytraautopilot/config.json";
        this.configFile = new File(configdir + moddir);
        this.loadSettings();
    }

    private void createAndShowSettings() {
        ConfigBuilder configBuilder = ConfigBuilder.create().setTitle((class_2561)new class_2588("text.elytraautopilot.title")).setSavingRunnable(this::saveSettings);
        ConfigCategory categoryGui = configBuilder.getOrCreateCategory((class_2561)new class_2588("text.elytraautopilot.gui"));
        ConfigCategory categoryFlightProfile = configBuilder.getOrCreateCategory((class_2561)new class_2588("text.elytraautopilot.flightprofile"));
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        categoryGui.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)new class_2588("text.elytraautopilot.showgui"), this.config.showgui).setDefaultValue(this.config.showgui).setSaveConsumer(x -> {
            this.config.showgui = x;
        }).build());
        categoryGui.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)new class_2588("text.elytraautopilot.guiX"), this.config.guiX).setDefaultValue(this.config.guiX).setSaveConsumer(x -> {
            this.config.guiX = x;
        }).build());
        categoryGui.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)new class_2588("text.elytraautopilot.guiY"), this.config.guiY).setDefaultValue(this.config.guiY).setSaveConsumer(y -> {
            this.config.guiY = y;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.pullUpAngle"), this.config.pullUpAngle).setDefaultValue(this.config.pullUpAngle).setSaveConsumer(x -> {
            this.config.pullUpAngle = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.pullDownAngle"), this.config.pullDownAngle).setDefaultValue(this.config.pullDownAngle).setSaveConsumer(x -> {
            this.config.pullDownAngle = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.pullUpMinVelocity"), this.config.pullUpMinVelocity).setDefaultValue(this.config.pullUpMinVelocity).setSaveConsumer(x -> {
            this.config.pullUpMinVelocity = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.pullDownMaxVelocity"), this.config.pullDownMaxVelocity).setDefaultValue(this.config.pullDownMaxVelocity).setSaveConsumer(x -> {
            this.config.pullDownMaxVelocity = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.pullUpSpeed"), this.config.pullUpSpeed).setDefaultValue(this.config.pullUpSpeed).setSaveConsumer(x -> {
            this.config.pullUpSpeed = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.pullDownSpeed"), this.config.pullDownSpeed).setDefaultValue(this.config.pullDownSpeed).setSaveConsumer(x -> {
            this.config.pullDownSpeed = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.maxHeight"), this.config.maxHeight).setDefaultValue(this.config.maxHeight).setSaveConsumer(y -> {
            this.config.maxHeight = y;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)new class_2588("text.elytraautopilot.autoLanding"), this.config.autoLanding).setDefaultValue(this.config.autoLanding).setSaveConsumer(x -> {
            this.config.autoLanding = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.autoLandSpeed"), this.config.autoLandSpeed).setDefaultValue(this.config.autoLandSpeed).setSaveConsumer(x -> {
            this.config.autoLandSpeed = x;
        }).build());
        categoryFlightProfile.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)new class_2588("text.elytraautopilot.turningSpeed"), this.config.turningSpeed).setDefaultValue(this.config.turningSpeed).setSaveConsumer(x -> {
            this.config.turningSpeed = x;
        }).build());
        this.minecraftClient.method_1507(configBuilder.build());
    }

    private void saveSettings() {
        Gson gson = new Gson();
        String configString = gson.toJson((Object)this.config);
        try {
            FileWriter writer = new FileWriter(this.configFile);
            writer.write(configString);
            writer.close();
            System.out.println("Saved settings");
        }
        catch (IOException e) {
            System.out.println("Error saving settings!");
        }
    }

    private void loadSettings() {
        this.config = new ElytraConfig();
        if (!this.configFile.exists() && this.configFile.getParentFile().mkdirs()) {
            try {
                if (this.configFile.createNewFile()) {
                    System.out.println("Created new config file");
                }
            }
            catch (IOException e) {
                System.out.println("Unable to load ElytraAutoPilot settings! Using default config");
            }
        } else {
            try {
                Scanner scanner = new Scanner(this.configFile);
                String output = "";
                while (scanner.hasNextLine()) {
                    scanner = new Scanner(this.configFile);
                    output = scanner.nextLine();
                }
                scanner.close();
                if (!output.equals("")) {
                    Gson gson = new Gson();
                    this.config = (ElytraConfig)gson.fromJson(output, ElytraConfig.class);
                    System.out.println("Loaded Settings");
                } else {
                    System.out.println("Unable to load ElytraAutoPilot settings! Using default config");
                }
            }
            catch (IOException e) {
                System.out.println("Unable to load ElytraAutoPilot settings! Using default config");
            }
        }
    }

    private void onTick() {
        double altitude;
        ++this._tick;
        if (this.minecraftClient == null) {
            this.minecraftClient = class_310.method_1551();
        }
        if (this.config == null) {
            this.loadSettings();
        }
        if (this.minecraftClient.field_1724 != null) {
            if (this.minecraftClient.field_1724.method_6128()) {
                this.showHud = true;
            } else {
                this.showHud = false;
                this.autoFlight = false;
            }
        }
        if (!this.lastPressed && keyBinding.method_1434() && this.minecraftClient.field_1724 != null) {
            if (this.minecraftClient.field_1724.method_6128()) {
                boolean bl = this.autoFlight = !this.autoFlight;
                if (this.autoFlight) {
                    this.isDescending = true;
                }
            } else {
                this.createAndShowSettings();
            }
        }
        this.lastPressed = keyBinding.method_1434();
        double distance = 0.0;
        if (this.autoFlight) {
            if (this.minecraftClient.field_1724 == null) {
                this.autoFlight = false;
                return;
            }
            altitude = this.minecraftClient.field_1724.method_19538().field_1351;
            float pitch = this.minecraftClient.field_1724.method_36455();
            if (this.isDescending) {
                this.pullUp = false;
                this.pullDown = true;
                if (altitude > this.config.maxHeight) {
                    this.velHigh = 0.3f;
                } else if (altitude > this.config.maxHeight - 10.0) {
                    this.velLow = 0.28475f;
                }
                double velMod = Math.max(this.velHigh, this.velLow);
                if (this.currentVelocity >= this.config.pullDownMaxVelocity + velMod) {
                    this.isDescending = false;
                    this.pullDown = false;
                    this.pullUp = true;
                }
            } else {
                this.velHigh = 0.0;
                this.velLow = 0.0;
                this.pullUp = true;
                this.pullDown = false;
                if (this.currentVelocity <= this.config.pullUpMinVelocity || altitude > this.config.maxHeight - 10.0) {
                    this.isDescending = true;
                    this.pullDown = true;
                    this.pullUp = false;
                }
            }
            if (this.isflytoActive) {
                if (this.isLanding) {
                    if (!this.config.autoLanding) {
                        this.isflytoActive = false;
                        this.isLanding = false;
                        return;
                    }
                    this.isDescending = true;
                    float yaw = class_3532.method_15393((float)this.minecraftClient.field_1724.method_36454());
                    this.minecraftClient.field_1724.method_36456((float)((double)yaw + this.config.autoLandSpeed));
                } else {
                    class_243 playerPosition = this.minecraftClient.field_1724.method_19538();
                    double f = (double)this.argXpos - playerPosition.field_1352;
                    double d = (double)this.argZpos - playerPosition.field_1350;
                    float targetYaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)d, (double)f) * 57.2957763671875) - 90.0f));
                    float yaw = class_3532.method_15393((float)this.minecraftClient.field_1724.method_36454());
                    if ((double)Math.abs(yaw - targetYaw) < this.config.turningSpeed * 2.0) {
                        this.minecraftClient.field_1724.method_36456(targetYaw);
                    } else {
                        if (yaw < targetYaw) {
                            this.minecraftClient.field_1724.method_36456((float)((double)yaw + this.config.turningSpeed));
                        }
                        if (yaw > targetYaw) {
                            this.minecraftClient.field_1724.method_36456((float)((double)yaw - this.config.turningSpeed));
                        }
                    }
                    distance = Math.sqrt(f * f + d * d);
                    if (distance < 20.0) {
                        this.isLanding = true;
                    }
                }
            }
            if (this.pullUp) {
                this.minecraftClient.field_1724.method_36457((float)((double)pitch - this.config.pullUpSpeed));
                pitch = this.minecraftClient.field_1724.method_36455();
                if ((double)pitch <= this.config.pullUpAngle) {
                    this.minecraftClient.field_1724.method_36457((float)this.config.pullUpAngle);
                }
            }
            if (this.pullDown) {
                this.minecraftClient.field_1724.method_36457((float)((double)pitch + this.config.pullDownSpeed));
                pitch = this.minecraftClient.field_1724.method_36455();
                if ((double)pitch >= this.config.pullDownAngle) {
                    this.minecraftClient.field_1724.method_36457((float)this.config.pullDownAngle);
                }
            }
        } else {
            this.velHigh = 0.0;
            this.velLow = 0.0;
            this.isLanding = false;
            this.isflytoActive = false;
            this.pullUp = false;
            this.pullDown = false;
        }
        if (this.showHud) {
            if (this.minecraftClient.field_1724 == null) {
                this.autoFlight = false;
                return;
            }
            this.computeVelocity();
            altitude = this.minecraftClient.field_1724.method_19538().field_1351;
            double avgVelocity = 0.0;
            if (this._tick >= 20) {
                ++this._index;
                if (this._index >= 60) {
                    this._index = 0;
                }
                if (this.velocityList.size() < 60) {
                    this.velocityList.add(this.currentVelocity);
                } else {
                    this.velocityList.set(this._index, this.currentVelocity);
                }
                this._tick = 0;
            }
            if (this.velocityList.size() >= 5) {
                avgVelocity = this.velocityList.stream().mapToDouble(val -> val).average().orElse(0.0);
            }
            if (this.hudString == null) {
                this.hudString = new String[7];
            }
            if (!this.config.showgui) {
                this.hudString[0] = "";
                this.hudString[1] = "";
                this.hudString[2] = "";
                this.hudString[3] = "";
                this.hudString[4] = "";
                this.hudString[5] = "";
                this.hudString[6] = "";
                return;
            }
            this.hudString[0] = "Auto flight : " + (this.autoFlight ? "Enabled" : "Disabled");
            this.hudString[1] = "Altitude : " + String.format("%.2f", altitude);
            this.hudString[2] = "Speed : " + String.format("%.2f", this.currentVelocity * 20.0) + " m/s";
            this.hudString[3] = avgVelocity == 0.0 ? "Calculating..." : "Avg. Speed : " + String.format("%.2f", avgVelocity * 20.0) + " m/s";
            if (this.isflytoActive) {
                this.hudString[4] = "Flying to : " + this.argXpos + ", " + this.argZpos;
                if (distance != 0.0) {
                    this.hudString[5] = "ETA : " + String.format("%.1f", distance / (avgVelocity * 20.0)) + " seconds";
                }
                this.hudString[6] = "Auto land : " + (this.config.autoLanding ? "Enabled" : "Disabled");
                if (this.isLanding) {
                    this.hudString[5] = "Landing...";
                }
            } else {
                this.hudString[4] = "";
                this.hudString[5] = "";
                this.hudString[6] = "";
            }
        } else {
            this.velocityList.clear();
        }
    }

    private void computeVelocity() {
        if (this.minecraftClient.field_1724 != null) {
            class_243 newPosition = this.minecraftClient.field_1724.method_19538();
            if (this.previousPosition == null) {
                this.previousPosition = newPosition;
            }
            class_243 difference = new class_243(newPosition.field_1352 - this.previousPosition.field_1352, newPosition.field_1351 - this.previousPosition.field_1351, newPosition.field_1350 - this.previousPosition.field_1350);
            this.previousPosition = newPosition;
            this.currentVelocity = difference.method_1033();
        }
    }

    public void onInitializeClient() {
        System.out.println("Hello Fabric world client ElytraAutoPilot!");
    }
}

