/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;

public class ClientInstaller {
    public static String install(Path mcDir, String gameVersion, String loaderVersion, InstallerProgress progress) throws IOException {
        System.out.println("Installing " + gameVersion + " with fabric " + loaderVersion);
        String profileName = String.format("%s-%s-%s", "fabric-loader", loaderVersion, gameVersion);
        Path versionsDir = mcDir.resolve("versions");
        Path profileDir = versionsDir.resolve(profileName);
        Path profileJson = profileDir.resolve(profileName + ".json");
        if (!Files.exists(profileDir, new LinkOption[0])) {
            Files.createDirectories(profileDir, new FileAttribute[0]);
        }
        Path dummyJar = profileDir.resolve(profileName + ".jar");
        Files.deleteIfExists(dummyJar);
        Files.createFile(dummyJar, new FileAttribute[0]);
        URL profileUrl = new URL(Reference.getMetaServerEndpoint(String.format("v2/versions/loader/%s/%s/profile/json", gameVersion, loaderVersion)));
        Utils.downloadFile(profileUrl, profileJson);
        progress.updateProgress(Utils.BUNDLE.getString("progress.done"));
        return profileName;
    }
}

