/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import mjson.Json;
import net.fabricmc.installer.util.Utils;

public class ProfileInstaller {
    public static void setupProfile(Path path, String name, String gameVersion) throws IOException {
        Path launcherProfiles = path.resolve("launcher_profiles.json");
        if (!Files.exists(launcherProfiles, new LinkOption[0])) {
            System.out.println("Could not find launcher_profiles");
            return;
        }
        System.out.println("Creating profile");
        Json jsonObject = Json.read(Utils.readString(launcherProfiles));
        Json profiles = jsonObject.at("profiles");
        String profileName = "fabric-loader-" + gameVersion;
        Json profile = profiles.has(profileName) ? profiles.at(profileName) : ProfileInstaller.createProfile(profileName);
        profile.set("lastVersionId", (Object)name);
        profiles.set(profileName, profile);
        Utils.writeToFile(launcherProfiles, jsonObject.toString());
    }

    private static Json createProfile(String name) {
        Json jsonObject = Json.object();
        jsonObject.set("name", (Object)name);
        jsonObject.set("type", (Object)"custom");
        jsonObject.set("created", (Object)Utils.ISO_8601.format(new Date()));
        jsonObject.set("lastUsed", (Object)Utils.ISO_8601.format(new Date()));
        jsonObject.set("icon", (Object)Utils.getProfileIcon());
        return jsonObject;
    }
}

