/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import mjson.Json;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Library;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;

public class ServerInstaller {
    private static final String servicesDir = "META-INF/services/";

    public static void install(File dir, String loaderVersion, String gameVersion, InstallerProgress progress) throws IOException {
        progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.installing.server")).format(new Object[]{String.format("%s(%s)", loaderVersion, gameVersion)}));
        File libsDir = new File(Utils.findDefaultUserDir(), ".cache" + File.separator + "fabric-installer" + File.separator + "libraries");
        if (!libsDir.exists() && !libsDir.mkdirs()) {
            throw new IOException("Could not create " + libsDir.getAbsolutePath() + "!");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Could not create " + dir.getAbsolutePath() + "!");
        }
        progress.updateProgress(Utils.BUNDLE.getString("progress.download.libraries"));
        URL profileUrl = new URL(Reference.getMetaServerEndpoint(String.format("v2/versions/loader/%s/%s/server/json", gameVersion, loaderVersion)));
        Json json = Json.read(Utils.readTextFile(profileUrl));
        ArrayList<File> libraryFiles = new ArrayList<File>();
        for (Json libraryJson : json.at("libraries").asJsonList()) {
            Library library = new Library(libraryJson);
            progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.download.library.entry")).format(new Object[]{library.name}));
            File libraryFile = new File(libsDir, library.getFileName());
            Utils.downloadFile(new URL(library.getURL()), libraryFile.toPath());
            libraryFiles.add(libraryFile);
        }
        progress.updateProgress(Utils.BUNDLE.getString("progress.generating.launch.jar"));
        File launchJar = new File(dir, "fabric-server-launch.jar");
        String mainClass = json.at("mainClass").asString();
        ServerInstaller.makeLaunchJar(launchJar, mainClass, libraryFiles, progress);
        progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.done.start.server")).format(new Object[]{launchJar.getName()}));
    }

    private static void makeLaunchJar(File file, String mainclass, List<File> libraryFiles, InstallerProgress progress) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getAbsolutePath());
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        HashSet<String> addedEntries = new HashSet<String>();
        addedEntries.add("META-INF/MANIFEST.MF");
        zipOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(new Attributes.Name("Manifest-Version"), "1.0");
        manifest.getMainAttributes().put(new Attributes.Name("Main-Class"), "net.fabricmc.loader.launch.server.FabricServerLauncher");
        manifest.write(zipOutputStream);
        zipOutputStream.closeEntry();
        addedEntries.add("fabric-server-launch.properties");
        zipOutputStream.putNextEntry(new ZipEntry("fabric-server-launch.properties"));
        zipOutputStream.write(("launch.mainClass=" + mainclass + "\n").getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
        HashMap<String, Set<String>> services = new HashMap<String, Set<String>>();
        byte[] buffer = new byte[32768];
        for (File file2 : libraryFiles) {
            progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.generating.launch.jar.library")).format(new Object[]{file2.getName()}));
            try (FileInputStream is = new FileInputStream(file2);
                 JarInputStream jis = new JarInputStream(is);){
                JarEntry entry;
                while ((entry = jis.getNextJarEntry()) != null) {
                    int r;
                    if (entry.isDirectory()) continue;
                    String name = entry.getName();
                    if (name.startsWith(servicesDir) && name.indexOf(47, servicesDir.length()) < 0) {
                        ServerInstaller.parseServiceDefinition(name, jis, services);
                        continue;
                    }
                    if (!addedEntries.add(name)) {
                        System.out.printf("duplicate file: %s%n", name);
                        continue;
                    }
                    JarEntry newEntry = new JarEntry(name);
                    zipOutputStream.putNextEntry(newEntry);
                    while ((r = jis.read(buffer, 0, buffer.length)) >= 0) {
                        zipOutputStream.write(buffer, 0, r);
                    }
                    zipOutputStream.closeEntry();
                }
            }
        }
        for (Map.Entry entry : services.entrySet()) {
            JarEntry newEntry = new JarEntry((String)entry.getKey());
            zipOutputStream.putNextEntry(newEntry);
            ServerInstaller.writeServiceDefinition((Collection)entry.getValue(), zipOutputStream);
            zipOutputStream.closeEntry();
        }
        zipOutputStream.close();
        outputStream.close();
    }

    private static void parseServiceDefinition(String name, InputStream rawIs, Map<String, Set<String>> services) throws IOException {
        String line;
        Collection out = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(rawIs, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            int pos = line.indexOf(35);
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            if ((line = line.trim()).isEmpty()) continue;
            if (out == null) {
                out = services.computeIfAbsent(name, ignore -> new LinkedHashSet());
            }
            out.add(line);
        }
    }

    private static void writeServiceDefinition(Collection<String> defs, OutputStream os) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        for (String def : defs) {
            writer.write(def);
            writer.write(10);
        }
        writer.flush();
    }
}

