/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import mjson.Json;
import net.fabricmc.installer.util.Utils;
import net.fabricmc.installer.util.VersionMeta;

public class LauncherMeta {
    private static LauncherMeta launcherMeta = null;
    public final List<Version> versions;

    public static LauncherMeta getLauncherMeta() throws IOException {
        if (launcherMeta == null) {
            launcherMeta = LauncherMeta.load();
        }
        return launcherMeta;
    }

    private static LauncherMeta load() throws IOException {
        URL url = new URL("https://launchermeta.mojang.com/mc/game/version_manifest_v2.json");
        String str = Utils.readTextFile(url);
        Json json = Json.read(str);
        List<Version> versions = json.at("versions").asJsonList().stream().map(Version::new).collect(Collectors.toList());
        return new LauncherMeta(versions);
    }

    public LauncherMeta(List<Version> versions) {
        this.versions = versions;
    }

    public Version getVersion(String version) {
        return this.versions.stream().filter(v -> v.id.equals(version)).findFirst().orElse(null);
    }

    public static class Version {
        public final String id;
        public final String url;
        private VersionMeta versionMeta = null;

        public Version(Json json) {
            this.id = json.at("id").asString();
            this.url = json.at("url").asString();
        }

        public VersionMeta getVersionMeta() throws IOException {
            if (this.versionMeta == null) {
                URL url = new URL(this.url);
                String str = Utils.readTextFile(url);
                Json json = Json.read(str);
                this.versionMeta = new VersionMeta(json);
            }
            return this.versionMeta;
        }
    }
}

