/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.File;
import mjson.Json;

public class Library {
    public final String name;
    public final String url;

    public Library(Json json) {
        this.name = json.at("name").asString();
        this.url = json.at("url").asString();
    }

    public String getURL() {
        String[] parts = this.name.split(":", 3);
        String path = parts[0].replace(".", "/") + "/" + parts[1] + "/" + parts[2] + "/" + parts[1] + "-" + parts[2] + ".jar";
        return this.url + path;
    }

    public String getPath() {
        String[] parts = this.name.split(":", 3);
        String path = parts[0].replace(".", File.separator) + File.separator + parts[1] + File.separator + parts[2] + File.separator + parts[1] + "-" + parts[2] + ".jar";
        return path.replaceAll(" ", "_");
    }

    public File getFile(File baseDir) {
        return new File(baseDir, this.getPath());
    }

    public String getFileName() {
        String path = this.getPath();
        return path.substring(path.lastIndexOf("\\") + 1);
    }
}

