/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class Utils {
    public static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("lang/installer", Locale.getDefault(), new ResourceBundle.Control(){

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            block11: {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                try (InputStream stream = loader.getResourceAsStream(resourceName);){
                    PropertyResourceBundle propertyResourceBundle;
                    if (stream == null) break block11;
                    try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        propertyResourceBundle = new PropertyResourceBundle(reader);
                    }
                    return propertyResourceBundle;
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    });

    public static File findDefaultUserDir() {
        String home = System.getProperty("user.home", ".");
        String os = System.getProperty("os.name").toLowerCase();
        File homeDir = new File(home);
        File dir = os.contains("win") && System.getenv("APPDATA") != null ? new File(System.getenv("APPDATA")) : (os.contains("mac") ? new File(homeDir, "Library" + File.separator + "Application Support") : homeDir);
        return dir;
    }

    public static File findDefaultInstallDir() {
        String home = System.getProperty("user.home", ".");
        String os = System.getProperty("os.name").toLowerCase();
        File homeDir = new File(home);
        File dir = os.contains("win") && System.getenv("APPDATA") != null ? new File(System.getenv("APPDATA"), ".minecraft") : (os.contains("mac") ? new File(homeDir, "Library" + File.separator + "Application Support" + File.separator + "minecraft") : new File(homeDir, ".minecraft"));
        return dir;
    }

    public static Reader urlReader(URL url) throws IOException {
        return new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
    }

    public static String readTextFile(URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(Utils.urlReader(url));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static String readString(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    public static void writeToFile(Path path, String string) throws IOException {
        Files.write(path, string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static void downloadFile(URL url, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (InputStream in = url.openStream();){
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static String getProfileIcon() {
        String string;
        block9: {
            InputStream is = Utils.class.getClassLoader().getResourceAsStream("profile_icon.png");
            try {
                int len;
                byte[] ret = new byte[4096];
                int offset = 0;
                while ((len = is.read(ret, offset, ret.length - offset)) != -1) {
                    if ((offset += len) != ret.length) continue;
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                string = "data:image/png;base64," + Base64.getEncoder().encodeToString(Arrays.copyOf(ret, offset));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "TNT";
                }
            }
            is.close();
        }
        return string;
    }
}

