/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.util;

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3854;
import net.minecraft.class_5635;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.mixin.NativeImageAccessor;
import randommcsomethin.fallingleaves.mixin.SpriteAccessor;
import randommcsomethin.fallingleaves.util.RegistryUtil;
import randommcsomethin.fallingleaves.util.TextureCache;

public class LeafUtil {
    private static final class_5819 renderRandom = class_5819.method_43053();

    public static double getModifiedSpawnChance(class_2680 state, LeafSettingsEntry leafSettings) {
        double spawnChance = leafSettings.getSpawnChance();
        if (FabricLoader.getInstance().isModLoaded("seasons")) {
            if (FabricSeasons.getCurrentSeason() == Season.FALL) {
                spawnChance *= Config.CONFIG.fallSpawnRateFactor;
            } else if (FabricSeasons.getCurrentSeason() == Season.WINTER) {
                spawnChance *= Config.CONFIG.winterSpawnRateFactor;
            }
        }
        if (Config.CONFIG.decaySpawnRateFactor != 1.0 && LeafUtil.isLeafBlock(state.method_26204(), true) && state.method_26204().method_9542(state)) {
            spawnChance *= Config.CONFIG.decaySpawnRateFactor;
        }
        return spawnChance;
    }

    public static void trySpawnLeafAndSnowParticle(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        double snowSpawnChance;
        LeafSettingsEntry leafSettings;
        double spawnChance;
        if (Config.CONFIG.startingSpawnRadius > 0) {
            assert (class_310.method_1551().field_1724 != null);
            if (LeafUtil.getMaximumDistance((class_2382)class_310.method_1551().field_1724.method_24515(), (class_2382)pos) < Config.CONFIG.startingSpawnRadius) {
                return;
            }
        }
        if ((spawnChance = LeafUtil.getModifiedSpawnChance(state, leafSettings = Objects.requireNonNull(LeafUtil.getLeafSettingsEntry(state)))) != 0.0 && random.method_43058() < spawnChance) {
            LeafUtil.spawnLeafParticles(1, false, state, world, pos, random, leafSettings);
        }
        if ((snowSpawnChance = Config.CONFIG.getSnowflakeSpawnChance()) != 0.0 && random.method_43058() < snowSpawnChance) {
            LeafUtil.spawnSnowParticles(1, false, state, world, pos, random, leafSettings);
        }
    }

    public static void spawnLeafParticles(int count, boolean spawnInsideBlock, class_2680 state, class_1937 world, class_2338 pos, class_5819 random, LeafSettingsEntry leafSettings) {
        if (count == 0) {
            return;
        }
        class_2388 params = new class_2388(leafSettings.isConiferBlock ? Leaves.FALLING_CONIFER_LEAF : Leaves.FALLING_LEAF, state);
        LeafUtil.spawnParticles(count, params, spawnInsideBlock, state, world, pos, random, leafSettings);
    }

    public static void spawnSnowParticles(int count, boolean spawnInsideBlock, class_2680 state, class_1937 world, class_2338 pos, class_5819 random, LeafSettingsEntry leafSettings) {
        if (count == 0) {
            return;
        }
        boolean snowy = false;
        if (class_3854.method_16930((class_6880)world.method_23753(pos)) == class_3854.field_17075) {
            snowy = true;
        } else {
            class_2248 topBlock = world.method_8320(world.method_8598(class_2902.class_2903.field_13202, pos).method_10074()).method_26204();
            boolean isSnowLayer = topBlock instanceof class_2488;
            if (isSnowLayer || topBlock == class_2246.field_10491 || topBlock instanceof class_5635) {
                snowy = true;
            }
        }
        if (!snowy) {
            return;
        }
        class_2388 params = new class_2388(Leaves.FALLING_SNOW, state);
        LeafUtil.spawnParticles(count, params, spawnInsideBlock, state, world, pos, random, leafSettings);
    }

    public static void spawnParticles(int count, class_2388 params, boolean spawnInsideBlock, class_2680 state, class_1937 world, class_2338 pos, class_5819 random, LeafSettingsEntry leafSettings) {
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            double y;
            double x = (double)pos.method_10263() + random.method_43058();
            double z = (double)pos.method_10260() + random.method_43058();
            if (spawnInsideBlock) {
                y = (double)pos.method_10264() + random.method_43058();
            } else {
                y = (double)pos.method_10264() - (state.method_26225() ? 0.1 : 0.0);
                if (!LeafUtil.hasRoomForLeafParticle(world, pos, x, y, z)) continue;
            }
            world.method_8406((class_2394)params, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static double[] getBlockTextureColor(class_2680 state, class_1937 world, class_2338 pos) {
        boolean shouldColor;
        class_1058 sprite;
        class_310 client = class_310.method_1551();
        class_1087 model = client.method_1541().method_3349(state);
        renderRandom.method_43052(state.method_26190(pos));
        List quads = model.method_4707(state, class_2350.field_11033, renderRandom);
        if (!quads.isEmpty()) {
            boolean useFirstQuad = true;
            class_2960 id = class_2378.field_11146.method_10221((Object)state.method_26204());
            if (id.method_12836().equals("byg")) {
                useFirstQuad = false;
            }
            class_777 quad = (class_777)quads.get(useFirstQuad ? 0 : quads.size() - 1);
            sprite = quad.method_35788();
            shouldColor = quad.method_3360();
        } else {
            sprite = model.method_4711();
            shouldColor = true;
        }
        class_2960 spriteId = sprite.method_4598();
        class_1011 texture = ((SpriteAccessor)sprite).getImages()[0];
        int blockColor = shouldColor ? client.method_1505().method_1697(state, (class_1920)world, pos, 0) : -1;
        return LeafUtil.calculateLeafColor(spriteId, texture, blockColor);
    }

    private static double[] calculateLeafColor(class_2960 spriteId, class_1011 texture, int blockColor) {
        double[] textureColor;
        TextureCache.Data cache = TextureCache.INST.get(spriteId);
        if (cache != null) {
            textureColor = cache.getColor();
        } else {
            textureColor = LeafUtil.averageColor(texture);
            TextureCache.INST.put(spriteId, new TextureCache.Data(textureColor));
            FallingLeavesClient.LOGGER.debug("{}: Calculated texture color {} ", (Object)spriteId, (Object)textureColor);
        }
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        return textureColor;
    }

    private static boolean hasRoomForLeafParticle(class_1937 world, class_2338 pos, double x, double y, double z) {
        if (LeafUtil.isLeafBlock(world.method_8320(pos.method_10074()).method_26204(), true)) {
            return false;
        }
        double y2 = y - (double)Config.CONFIG.minimumFreeSpaceBelow * 0.5;
        class_238 collisionBox = new class_238(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.method_20812(null, collisionBox).iterator().hasNext();
    }

    public static Map<class_2960, LeafSettingsEntry> getRegisteredLeafBlocks(boolean useBlockTags) {
        return class_2378.field_11146.method_10235().stream().filter(entry -> LeafUtil.isLeafBlock((class_2248)class_2378.field_11146.method_10223(entry), useBlockTags)).collect(Collectors.toMap(Function.identity(), LeafSettingsEntry::new));
    }

    public static boolean isLeafBlock(class_2248 block, boolean useBlockTags) {
        return block instanceof class_2397 || useBlockTags && block.method_9564().method_26164(class_3481.field_15503);
    }

    @Nullable
    public static LeafSettingsEntry getLeafSettingsEntry(class_2680 blockState) {
        return Config.CONFIG.leafSettings.get(RegistryUtil.getBlockId(blockState));
    }

    public static int getMaximumDistance(class_2382 v1, class_2382 v2) {
        int dx = Math.abs(v1.method_10263() - v2.method_10263());
        int dy = Math.abs(v1.method_10264() - v2.method_10264());
        int dz = Math.abs(v1.method_10260() - v2.method_10260());
        return Math.max(dx, Math.max(dy, dz));
    }

    public static double[] averageColor(class_1011 image) {
        if (image.method_4318() != class_1011.class_1012.field_4997) {
            FallingLeavesClient.LOGGER.error("RGBA image required, was {}", (Object)image.method_4318());
            return new double[]{1.0, 1.0, 1.0};
        }
        NativeImageAccessor imageAcc = (NativeImageAccessor)image;
        long pointer = imageAcc.getPointer();
        if (pointer == 0L) {
            FallingLeavesClient.LOGGER.error("image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.method_4307();
        int height = image.method_4323();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pointer + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }
}

