/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.util;

import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.init.Leaves;
import de.cheaterpaul.fallingleaves.util.TextureCache;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class LeafUtil {
    public static void trySpawnLeafParticle(BlockState state, Level world, BlockPos pos, Random random, @Nullable LeafSettingsEntry leafSettings) {
        double z;
        double y;
        double x = (double)pos.m_123341_() + random.nextDouble();
        if (LeafUtil.shouldSpawnParticle(world, pos, x, y = (double)pos.m_123342_() - random.nextDouble() / 3.0, z = (double)pos.m_123343_() + random.nextDouble())) {
            IModelData modelData;
            Minecraft client = Minecraft.m_91087_();
            BakedModel model = client.m_91289_().m_110910_(state);
            List quads = model.getQuads(state, null, random, modelData = model.getModelData((BlockAndTintGetter)world, pos, state, (IModelData)EmptyModelData.INSTANCE));
            boolean shouldColor = quads.isEmpty() || quads.stream().anyMatch(BakedQuad::m_111304_);
            int blockColor = client.m_91298_().m_92577_(state, (BlockAndTintGetter)world, pos, 0);
            ResourceLocation texture = LeafUtil.spriteToTexture(client.m_91304_().m_119430_().getTexture(state, world, pos));
            double[] color = LeafUtil.calculateLeafColor(texture, shouldColor, blockColor, client);
            double r = color[0];
            double g = color[1];
            double b = color[2];
            world.m_7106_((ParticleOptions)(leafSettings == null || !leafSettings.isConiferBlock ? Leaves.falling_leaf : Leaves.falling_leaf_conifer), x, y, z, r, g, b);
        }
    }

    private static double[] calculateLeafColor(ResourceLocation texture, boolean shouldColor, int blockColor, Minecraft client) {
        double[] dArray;
        block18: {
            Resource res = client.m_91098_().m_142591_(texture);
            try {
                double[] textureColor;
                String resourcePack = res.m_7816_();
                TextureCache.Data cache = TextureCache.INST.get(texture);
                if (cache != null && resourcePack.equals(cache.resourcePack)) {
                    textureColor = cache.getColor();
                } else {
                    try (InputStream is = res.m_6679_();){
                        textureColor = LeafUtil.averageColor(ImageIO.read(is));
                        TextureCache.INST.put(texture, new TextureCache.Data(textureColor, resourcePack));
                        FallingLeavesMod.LOGGER.debug("{}: Calculated texture color {} ", (Object)texture, (Object)textureColor);
                    }
                }
                if (shouldColor && blockColor != -1) {
                    textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
                    textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
                    textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
                }
                dArray = textureColor;
                if (res == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    FallingLeavesMod.LOGGER.error("Couldn't access resource {}", (Object)texture, (Object)e);
                    return new double[]{1.0, 1.0, 1.0};
                }
            }
            res.close();
        }
        return dArray;
    }

    private static boolean shouldSpawnParticle(Level world, BlockPos pos, double x, double y, double z) {
        if (LeafUtil.isLeafBlock(world.m_8055_(pos.m_7495_()).m_60734_(), true)) {
            return false;
        }
        double y2 = y - (double)((Integer)FallingLeavesConfig.CONFIG.minimumFreeSpaceBelow.get()).intValue() * 0.5;
        AABB collisionBox = new AABB(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.m_45761_(null, collisionBox).findAny().isPresent();
    }

    public static boolean isLeafBlock(Block block, boolean useBlockTags) {
        return block instanceof LeavesBlock || useBlockTags && BlockTags.f_13035_.m_8110_((Object)block);
    }

    public static double[] averageColor(BufferedImage image) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Color c = new Color(image.getRGB(x, y), true);
                if (c.getAlpha() != 255) continue;
                r += (double)c.getRed();
                g += (double)c.getGreen();
                b += (double)c.getBlue();
                ++n;
            }
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }

    public static ResourceLocation spriteToTexture(TextureAtlasSprite sprite) {
        String texture = sprite.m_118413_().m_135815_();
        return new ResourceLocation(sprite.m_118413_().m_135827_(), "textures/" + texture + ".png");
    }
}

