/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    public final ModConfigSpec.IntValue leafSize;
    public final ModConfigSpec.IntValue leafLifespan;
    public final ModConfigSpec.IntValue leafSpawnRate;
    public final ModConfigSpec.IntValue coniferLeafSpawnRate;
    public final ModConfigSpec.BooleanValue dropFromPlayerPlacedBlocks;
    public final ModConfigSpec.IntValue minimumFreeSpaceBelow;
    public final ModConfigSpec.BooleanValue disableWind;
    public final ModConfigSpec.ConfigValue<List<? extends String>> windlessDimension;

    public ClientConfig(ModConfigSpec.Builder builder) {
        this.leafSize = builder.comment("modifies the size of the leaves").defineInRange("leafSize", 4, 1, 20);
        this.leafLifespan = builder.comment(new String[]{"modifies how long it takes for the leaves to disappear", "Values over 2000 are not recommend"}).defineInRange("leafLifespan", 200, 100, Integer.MAX_VALUE);
        this.leafSpawnRate = builder.comment(new String[]{"modifies the amount of leaves that are spawning", "Values over 10000 are not recommend"}).defineInRange("leafSpawnRate", 10, 0, Integer.MAX_VALUE);
        this.coniferLeafSpawnRate = builder.comment(new String[]{"modifier the amount of leaves are spawning from conifer trees", "Values over 10000 are not recommend"}).defineInRange("coniferLeafSpawnRate", 2, 0, Integer.MAX_VALUE);
        this.dropFromPlayerPlacedBlocks = builder.comment("whether player placed blocks should also drop leaves").define("dropFromPlayerPlacedBlocks", true);
        this.minimumFreeSpaceBelow = builder.comment("how much room below the leaves block is needed for the leaves to spawn").defineInRange("minimumFreeSpaceBelow", 1, 1, 20);
        this.disableWind = builder.comment("disable wind effects").define("disableWind", false);
        this.windlessDimension = builder.comment("windless dimensions").defineList("windlessDimension", (List)Lists.newArrayList((Object[])new String[]{BuiltinDimensionTypes.NETHER.location().toString(), BuiltinDimensionTypes.END.location().toString()}), string -> string instanceof String && ResourceLocation.tryParse((String)((String)string)) != null);
    }
}

