/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.events;

import com.edek.dg.FlashLight;
import com.edek.dg.config.FlashConfig;
import com.edek.dg.tileentity.TileEntityLightSource;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEventHandler {
    float range = ((Integer)FlashConfig.range.get()).intValue();
    float spread = ((Integer)FlashConfig.spread.get()).intValue();

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.phase == TickEvent.Phase.START && (player.func_184614_ca() != null && FlashLight.flashLightItem.isPresent() && player.func_184614_ca().func_77973_b() == FlashLight.flashLightItem.get() && player.func_184614_ca().func_77942_o() && player.func_184614_ca().func_77978_p().func_74767_n("active") || player.func_184592_cb() != null && FlashLight.flashLightItem.isPresent() && player.func_184592_cb().func_77973_b() == FlashLight.flashLightItem.get() && player.func_184592_cb().func_77942_o() && player.func_184592_cb().func_77978_p().func_74767_n("active"))) {
            World world = player.field_70170_p;
            BlockRayTraceResult mop = this.getLookMOP(player, this.range, 0.0f, 0.0f);
            if (mop != null) {
                int x = (int)mop.func_216347_e().func_82615_a();
                int y = (int)mop.func_216347_e().func_82617_b();
                int z = (int)mop.func_216347_e().func_82616_c();
                boolean createLight = false;
                if (!world.func_175623_d(new BlockPos(x, y, z))) {
                    if (mop.func_216354_b() == Direction.DOWN) {
                        y -= 2;
                    }
                    if (mop.func_216354_b() == Direction.UP) {
                        y += 2;
                    }
                    if (mop.func_216354_b() == Direction.NORTH) {
                        z -= 2;
                    }
                    if (mop.func_216354_b() == Direction.SOUTH) {
                        z += 2;
                    }
                    if (mop.func_216354_b() == Direction.WEST) {
                        x -= 2;
                    }
                    if (mop.func_216354_b() == Direction.EAST) {
                        x += 2;
                    }
                    if (!world.func_175623_d(new BlockPos(x, y, z)) && !world.func_175623_d(new BlockPos(x -= 2, y, z))) {
                        z -= 2;
                    }
                    createLight = world.func_175623_d(new BlockPos(x, y, z));
                } else {
                    createLight = true;
                }
                if (createLight) {
                    TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
                    if (tile instanceof TileEntityLightSource) {
                        ((TileEntityLightSource)tile).ticksExisted = 0;
                    } else if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != FlashLight.lightSourceBlock.get()) {
                        world.func_180501_a(new BlockPos(x, y, z), ((Block)FlashLight.lightSourceBlock.get()).func_176223_P(), 1);
                    }
                }
            }
            for (int i = 0; i < 5; ++i) {
                float yaw = 0.0f;
                float pitch = 0.0f;
                switch (i) {
                    case 1: {
                        yaw += this.spread;
                        break;
                    }
                    case 2: {
                        pitch += this.spread;
                        break;
                    }
                    case 3: {
                        yaw -= this.spread;
                        break;
                    }
                    case 4: {
                        pitch -= this.spread;
                    }
                }
                BlockRayTraceResult mop1 = this.getLookMOP(player, this.range, yaw, pitch);
                if (mop1 == null) continue;
                int x = (int)mop1.func_216347_e().func_82615_a();
                int y = (int)mop1.func_216347_e().func_82617_b();
                int z = (int)mop1.func_216347_e().func_82616_c();
                boolean createLight = false;
                if (!world.func_175623_d(new BlockPos(x, y, z))) {
                    if (mop1.func_216354_b() == Direction.DOWN) {
                        y -= 2;
                    }
                    if (mop1.func_216354_b() == Direction.UP) {
                        y += 2;
                    }
                    if (mop1.func_216354_b() == Direction.NORTH) {
                        z -= 2;
                    }
                    if (mop1.func_216354_b() == Direction.SOUTH) {
                        z += 2;
                    }
                    if (mop1.func_216354_b() == Direction.WEST) {
                        x -= 2;
                    }
                    if (mop1.func_216354_b() == Direction.EAST) {
                        x += 2;
                    }
                    if (!world.func_175623_d(new BlockPos(x, y, z)) && !world.func_175623_d(new BlockPos(x -= 2, y, z))) {
                        z -= 2;
                    }
                    createLight = world.func_175623_d(new BlockPos(x, y, z));
                } else {
                    createLight = true;
                }
                if (!createLight) continue;
                TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
                if (tile instanceof TileEntityLightSource) {
                    ((TileEntityLightSource)tile).ticksExisted = 0;
                    continue;
                }
                if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == FlashLight.lightSourceBlock.get()) continue;
                world.func_180501_a(new BlockPos(x, y, z), ((Block)FlashLight.lightSourceBlock.get()).func_176223_P(), 1);
            }
        }
    }

    protected BlockRayTraceResult getLookMOP(PlayerEntity player, double searchRange, float yaw, float pitch) {
        float f = 1.0f;
        float rotYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f + yaw;
        float rotPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f + pitch;
        double x = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)f;
        double y = player.field_70137_T + 1.0 + (player.func_226278_cu_() - player.field_70137_T) * (double)f + (double)(player.field_70170_p.func_201670_d() ? player.func_70047_e() - 1.62f : player.func_70047_e());
        double z = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)f;
        Vector3d vec3 = new Vector3d(x, y, z);
        float f3 = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vector3d vec31 = vec3.func_72441_c((double)f7 * searchRange, (double)f6 * searchRange, (double)f8 * searchRange);
        RayTraceContext context = new RayTraceContext(vec3, vec31, RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, (Entity)player);
        return player.field_70170_p.func_217299_a(context);
    }
}

