/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.events;

import com.edek.dg.config.FlashConfig;
import com.edek.dg.registers.BlockRegister;
import com.edek.dg.registers.ItemRegister;
import com.edek.dg.tileentity.TileEntityLightSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CommonEventHandler {
    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.START && (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ItemRegister.flashLight && player.func_184614_ca().func_77942_o() && player.func_184614_ca().func_77978_p().func_74767_n("active") || player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == ItemRegister.flashLight && player.func_184592_cb().func_77942_o() && player.func_184592_cb().func_77978_p().func_74767_n("active"))) {
            World world = player.field_70170_p;
            float range = FlashConfig.range;
            float spread = FlashConfig.spread;
            RayTraceResult mop = this.getLookMOP(player, range, 0.0f, 0.0f);
            if (mop != null) {
                int x = (int)mop.field_72307_f.field_72450_a;
                int y = (int)mop.field_72307_f.field_72448_b;
                int z = (int)mop.field_72307_f.field_72449_c;
                EnumFacing side = mop.field_178784_b;
                boolean createLight = false;
                if (!world.func_175623_d(new BlockPos(x, y, z))) {
                    if (side == EnumFacing.DOWN) {
                        y -= 2;
                    }
                    if (side == EnumFacing.UP) {
                        y += 2;
                    }
                    if (side == EnumFacing.NORTH) {
                        z -= 2;
                    }
                    if (side == EnumFacing.SOUTH) {
                        z += 2;
                    }
                    if (side == EnumFacing.WEST) {
                        x -= 2;
                    }
                    if (side == EnumFacing.EAST) {
                        x += 2;
                    }
                    if (!world.func_175623_d(new BlockPos(x, y, z)) && !world.func_175623_d(new BlockPos(x -= 2, y, z))) {
                        z -= 2;
                    }
                    createLight = world.func_175623_d(new BlockPos(x, y, z));
                } else {
                    createLight = true;
                }
                if (createLight) {
                    TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
                    if (tile instanceof TileEntityLightSource) {
                        ((TileEntityLightSource)tile).ticksExisted = 0;
                    } else if (world.func_180495_p(new BlockPos(x, y, z)) != BlockRegister.lightSource) {
                        world.func_175656_a(new BlockPos(x, y, z), BlockRegister.lightSource.func_176223_P());
                    }
                }
            }
            for (int i = 0; i < 5; ++i) {
                float yaw = 0.0f;
                float pitch = 0.0f;
                switch (i) {
                    case 1: {
                        yaw += spread;
                        break;
                    }
                    case 2: {
                        pitch += spread;
                        break;
                    }
                    case 3: {
                        yaw -= spread;
                        break;
                    }
                    case 4: {
                        pitch -= spread;
                    }
                }
                RayTraceResult mop1 = this.getLookMOP(player, range, yaw, pitch);
                if (mop1 == null) continue;
                int x = (int)mop1.field_72307_f.field_72450_a;
                int y = (int)mop1.field_72307_f.field_72448_b;
                int z = (int)mop1.field_72307_f.field_72449_c;
                EnumFacing side = mop1.field_178784_b;
                boolean createLight = false;
                if (!world.func_175623_d(new BlockPos(x, y, z))) {
                    if (side == EnumFacing.DOWN) {
                        y -= 2;
                    }
                    if (side == EnumFacing.UP) {
                        y += 2;
                    }
                    if (side == EnumFacing.NORTH) {
                        z -= 2;
                    }
                    if (side == EnumFacing.SOUTH) {
                        z += 2;
                    }
                    if (side == EnumFacing.WEST) {
                        x -= 2;
                    }
                    if (side == EnumFacing.EAST) {
                        x += 2;
                    }
                    if (!world.func_175623_d(new BlockPos(x, y, z)) && !world.func_175623_d(new BlockPos(x -= 2, y, z))) {
                        z -= 2;
                    }
                    createLight = world.func_175623_d(new BlockPos(x, y, z));
                } else {
                    createLight = true;
                }
                if (!createLight) continue;
                TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
                if (tile instanceof TileEntityLightSource) {
                    ((TileEntityLightSource)tile).ticksExisted = 0;
                    continue;
                }
                if (world.func_180495_p(new BlockPos(x, y, z)) == BlockRegister.lightSource) continue;
                world.func_175656_a(new BlockPos(x, y, z), BlockRegister.lightSource.func_176223_P());
            }
        }
    }

    protected RayTraceResult getLookMOP(EntityPlayer player, double searchRange, float yaw, float pitch) {
        float f = 1.0f;
        float rotYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f + yaw;
        float rotPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f + pitch;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double y = player.field_70167_r + 1.0 + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(player.field_70170_p.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(x, y, z);
        float f3 = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * searchRange, (double)f6 * searchRange, (double)f8 * searchRange);
        return player.field_70170_p.func_147447_a(vec3, vec31, true, true, true);
    }
}

