/*
 * Decompiled with CFR 0.152.
 */
package net.thedudemc.freelook.event;

import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.thedudemc.freelook.init.ModConfigs;
import net.thedudemc.freelook.init.ModKeybinds;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CameraEvents {
    private static Minecraft minecraft;
    private static LocalPlayer player;
    private static float yaw;
    private static float pitch;
    private static float prevYaw;
    private static float prevPitch;
    private static float originalYaw;
    private static float originalPitch;
    private static float originalHeadYaw;
    private static double mouseDX;
    private static double mouseDY;
    private static double prevMouseX;
    private static double prevMouseY;
    private static long lerpStart;
    private static long lerpTimeElapsed;
    private static boolean initialPress;
    private static boolean isInterpolating;
    private static boolean toggle;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (ModKeybinds.keyToggleMode.m_90859_()) {
            toggle = !toggle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onCameraUpdate(EntityViewRenderEvent.CameraSetup event) {
        if (CameraEvents.getMinecraft().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        if (ModKeybinds.keyFreeLook.m_90857_() || toggle) {
            if (initialPress) {
                CameraEvents.reset(event);
                CameraEvents.setup();
                initialPress = false;
            }
            CameraEvents.lockPlayerRotation();
            CameraEvents.updateMouseInput();
            CameraEvents.updateCameraRotation(event);
        } else if (isInterpolating) {
            CameraEvents.lockPlayerRotation();
            CameraEvents.interpolate(event);
        } else if (!initialPress) {
            if (ModConfigs.FREELOOK.shouldInterpolate()) {
                event.setYaw(yaw);
                event.setPitch(pitch);
                CameraEvents.startInterpolation();
            } else {
                CameraEvents.reset(event);
            }
            initialPress = true;
        }
    }

    private static void startInterpolation() {
        lerpStart = System.currentTimeMillis();
        isInterpolating = true;
    }

    private static void setup() {
        originalYaw = CameraEvents.getPlayer().m_146908_();
        originalPitch = CameraEvents.getPlayer().m_146909_();
        originalHeadYaw = CameraEvents.getPlayer().f_20885_;
        prevMouseX = CameraEvents.getMinecraft().f_91067_.m_91589_();
        prevMouseY = CameraEvents.getMinecraft().f_91067_.m_91594_();
    }

    private static void updateCameraRotation(EntityViewRenderEvent.CameraSetup event) {
        double dx = mouseDX * CameraEvents.getSensitivity() * 0.15;
        double dy = mouseDY * CameraEvents.getSensitivity() * 0.15;
        yaw = (float)dx - prevYaw + originalYaw;
        pitch = CameraEvents.getMinecraft().f_91066_.f_92044_ ? (float)dy + prevPitch + originalPitch : (float)dy - prevPitch + originalPitch;
        if (ModConfigs.FREELOOK.shouldClamp()) {
            yaw = Mth.m_14036_((float)yaw, (float)(originalYaw + -100.0f), (float)(originalYaw + 100.0f));
        }
        pitch = Mth.m_14036_((float)pitch, (float)-90.0f, (float)90.0f);
        prevYaw = Mth.m_14036_((float)((float)dx + prevYaw), (float)-99.0f, (float)99.0f);
        prevPitch = (float)dy + prevPitch;
        event.setYaw(yaw);
        event.setPitch(pitch);
    }

    private static void interpolate(EntityViewRenderEvent.CameraSetup event) {
        double duration = ModConfigs.FREELOOK.getInterpolateSpeed() * 1000.0;
        float delta = System.currentTimeMillis() - lerpStart - lerpTimeElapsed;
        delta = (float)((double)delta / duration);
        float percentCompleted = (float)lerpTimeElapsed / (float)duration;
        float interpolatedYaw = CameraEvents.lerp(yaw, originalYaw, percentCompleted * 10.0f * delta);
        float interpolatedPitch = CameraEvents.lerp(pitch, originalPitch, percentCompleted * 10.0f * delta);
        event.setYaw(interpolatedYaw);
        event.setPitch(interpolatedPitch);
        yaw = interpolatedYaw;
        pitch = interpolatedPitch;
        lerpTimeElapsed = System.currentTimeMillis() - lerpStart;
        if ((double)lerpTimeElapsed >= duration) {
            CameraEvents.reset(event);
        }
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static void reset(EntityViewRenderEvent.CameraSetup event) {
        event.setYaw(originalYaw);
        event.setPitch(originalPitch);
        isInterpolating = false;
        lerpTimeElapsed = 0L;
        yaw = 0.0f;
        pitch = 0.0f;
        prevYaw = 0.0f;
        prevPitch = 0.0f;
        mouseDX = 0.0;
        mouseDY = 0.0;
        prevMouseX = 0.0;
        prevMouseY = 0.0;
        player = null;
        minecraft = null;
    }

    private static void lockPlayerRotation() {
        CameraEvents.getPlayer().m_146922_(originalYaw);
        CameraEvents.getPlayer().m_146926_(originalPitch);
        CameraEvents.getPlayer().f_20885_ = originalHeadYaw;
    }

    private static void updateMouseInput() {
        mouseDX = prevMouseX - CameraEvents.getMinecraft().f_91067_.m_91589_();
        mouseDY = prevMouseY - CameraEvents.getMinecraft().f_91067_.m_91594_();
        prevMouseX = CameraEvents.getMinecraft().f_91067_.m_91589_();
        prevMouseY = CameraEvents.getMinecraft().f_91067_.m_91594_();
    }

    private static double getSensitivity() {
        return CameraEvents.getMinecraft().f_91066_.f_92053_ * 0.6 * 0.2 * 8.0;
    }

    private static LocalPlayer getPlayer() {
        if (player == null) {
            player = CameraEvents.getMinecraft().f_91074_;
        }
        return player;
    }

    private static Minecraft getMinecraft() {
        if (minecraft == null) {
            minecraft = Minecraft.m_91087_();
        }
        return minecraft;
    }

    static {
        lerpStart = 0L;
        lerpTimeElapsed = 0L;
        initialPress = true;
        isInterpolating = false;
        toggle = false;
    }
}

