/*
 * Decompiled with CFR 0.152.
 */
package net.ninjadev.freelook.event;

import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import net.ninjadev.freelook.init.ModConfigs;
import net.ninjadev.freelook.init.ModKeybinds;
import net.ninjadev.freelook.mixin.CameraAccessor;

public class CameraEvents {
    private static class_310 minecraft;
    private static class_746 player;
    private static float yaw;
    private static float pitch;
    private static float prevYaw;
    private static float prevPitch;
    private static float originalYaw;
    private static float originalPitch;
    private static float originalHeadYaw;
    private static double mouseDX;
    private static double mouseDY;
    private static double prevMouseX;
    private static double prevMouseY;
    private static long lerpStart;
    private static long lerpTimeElapsed;
    private static boolean initialPress;
    public static boolean isInterpolating;
    public static boolean toggle;
    public static boolean isFreelooking;

    public static void onClientTick() {
        if (ModKeybinds.keyToggleMode.method_1436()) {
            toggle = !toggle;
        }
    }

    public static void onCameraUpdate(class_4184 camera) {
        if (CameraEvents.getMinecraft().field_1690.method_31044() == class_5498.field_26666) {
            return;
        }
        if (ModKeybinds.keyFreeLook.method_1434() || toggle) {
            isFreelooking = true;
            if (initialPress) {
                CameraEvents.reset(camera);
                CameraEvents.setup();
                initialPress = false;
            }
            CameraEvents.lockPlayerRotation();
            CameraEvents.updateMouseInput();
            CameraEvents.updateCameraRotation(camera);
        } else if (isInterpolating) {
            CameraEvents.lockPlayerRotation();
            CameraEvents.interpolate(camera);
        } else {
            if (!initialPress) {
                if (ModConfigs.FREELOOK.shouldInterpolate()) {
                    ((CameraAccessor)camera).setYaw(yaw);
                    ((CameraAccessor)camera).setPitch(pitch);
                    CameraEvents.startInterpolation();
                } else {
                    CameraEvents.reset(camera);
                }
                initialPress = true;
            }
            isFreelooking = false;
        }
    }

    private static void startInterpolation() {
        lerpStart = System.currentTimeMillis();
        isInterpolating = true;
    }

    private static void setup() {
        originalYaw = CameraEvents.getPlayer().method_36454();
        originalPitch = CameraEvents.getPlayer().method_36455();
        originalHeadYaw = CameraEvents.getPlayer().field_6241;
        prevMouseX = CameraEvents.getMinecraft().field_1729.method_1603();
        prevMouseY = CameraEvents.getMinecraft().field_1729.method_1604();
    }

    private static void updateCameraRotation(class_4184 camera) {
        double dx = mouseDX * CameraEvents.getSensitivity() * 0.15;
        double dy = mouseDY * CameraEvents.getSensitivity() * 0.15;
        yaw = (float)dx - prevYaw + originalYaw;
        pitch = (Boolean)CameraEvents.getMinecraft().field_1690.method_42438().method_41753() != false ? (float)dy + prevPitch + originalPitch : (float)dy - prevPitch + originalPitch;
        if (ModConfigs.FREELOOK.shouldClamp()) {
            yaw = class_3532.method_15363((float)yaw, (float)(originalYaw + -100.0f), (float)(originalYaw + 100.0f));
        }
        pitch = class_3532.method_15363((float)pitch, (float)-89.0f, (float)89.0f);
        prevYaw = class_3532.method_15363((float)((float)dx + prevYaw), (float)-99.0f, (float)99.0f);
        prevPitch = class_3532.method_15363((float)((float)dy + prevPitch), (float)-89.0f, (float)89.0f);
        ((CameraAccessor)camera).setYaw(yaw);
        ((CameraAccessor)camera).setPitch(pitch);
    }

    private static void interpolate(class_4184 camera) {
        double duration = ModConfigs.FREELOOK.getInterpolateSpeed() * 1000.0;
        float delta = System.currentTimeMillis() - lerpStart - lerpTimeElapsed;
        delta = (float)((double)delta / duration);
        float percentCompleted = (float)lerpTimeElapsed / (float)duration;
        float interpolatedYaw = CameraEvents.lerp(yaw, originalYaw, percentCompleted * 10.0f * delta);
        float interpolatedPitch = CameraEvents.lerp(pitch, originalPitch, percentCompleted * 10.0f * delta);
        ((CameraAccessor)camera).setYaw(yaw);
        ((CameraAccessor)camera).setPitch(pitch);
        yaw = interpolatedYaw;
        pitch = interpolatedPitch;
        lerpTimeElapsed = System.currentTimeMillis() - lerpStart;
        if ((double)lerpTimeElapsed >= duration) {
            CameraEvents.reset(camera);
        }
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static void reset(class_4184 camera) {
        ((CameraAccessor)camera).setYaw(yaw);
        ((CameraAccessor)camera).setPitch(pitch);
        isInterpolating = false;
        lerpTimeElapsed = 0L;
        yaw = 0.0f;
        pitch = 0.0f;
        prevYaw = 0.0f;
        prevPitch = 0.0f;
        mouseDX = 0.0;
        mouseDY = 0.0;
        prevMouseX = 0.0;
        prevMouseY = 0.0;
        player = null;
        minecraft = null;
    }

    private static void lockPlayerRotation() {
        CameraEvents.getPlayer().method_36456(originalYaw);
        CameraEvents.getPlayer().method_36457(originalPitch);
        CameraEvents.getPlayer().field_6241 = originalHeadYaw;
    }

    private static void updateMouseInput() {
        mouseDX = prevMouseX - CameraEvents.getMinecraft().field_1729.method_1603();
        mouseDY = prevMouseY - CameraEvents.getMinecraft().field_1729.method_1604();
        prevMouseX = CameraEvents.getMinecraft().field_1729.method_1603();
        prevMouseY = CameraEvents.getMinecraft().field_1729.method_1604();
    }

    private static double getSensitivity() {
        return Math.pow((Double)CameraEvents.getMinecraft().field_1690.method_42495().method_41753() * 0.6 + 0.2, 3.0) * 8.0;
    }

    private static class_746 getPlayer() {
        if (player == null) {
            player = CameraEvents.getMinecraft().field_1724;
        }
        return player;
    }

    private static class_310 getMinecraft() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        return minecraft;
    }

    public static boolean shouldUpdate() {
        return ModKeybinds.keyFreeLook.method_1434() || toggle || isFreelooking || isInterpolating;
    }

    static {
        lerpStart = 0L;
        lerpTimeElapsed = 0L;
        initialPress = true;
        isInterpolating = false;
        toggle = false;
        isFreelooking = false;
    }
}

