/*
 * Decompiled with CFR 0.152.
 */
package net.ninjadev.freelook.event;

import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.ninjadev.freelook.init.ModConfigs;
import net.ninjadev.freelook.init.ModKeybinds;
import net.ninjadev.freelook.mixin.CameraAccessor;

public class CameraEvents {
    private static Minecraft minecraft;
    private static LocalPlayer player;
    private static float yaw;
    private static float pitch;
    private static float prevYaw;
    private static float prevPitch;
    private static float originalYaw;
    private static float originalPitch;
    private static float originalHeadYaw;
    private static double mouseDX;
    private static double mouseDY;
    private static double prevMouseX;
    private static double prevMouseY;
    private static long lerpStart;
    private static long lerpTimeElapsed;
    private static boolean initialPress;
    public static boolean isInterpolating;
    public static boolean toggle;
    public static boolean isFreelooking;

    public static void onClientTick() {
        if (ModKeybinds.keyToggleMode.m_90859_()) {
            toggle = !toggle;
        }
    }

    public static void onCameraUpdate(Camera camera) {
        if (CameraEvents.getMinecraft().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
            return;
        }
        if (ModKeybinds.keyFreeLook.m_90857_() || toggle) {
            isFreelooking = true;
            if (initialPress) {
                CameraEvents.reset(camera);
                CameraEvents.setup();
                initialPress = false;
            }
            CameraEvents.lockPlayerRotation();
            CameraEvents.updateMouseInput();
            CameraEvents.updateCameraRotation(camera);
        } else if (isInterpolating) {
            CameraEvents.lockPlayerRotation();
            CameraEvents.interpolate(camera);
        } else {
            if (!initialPress) {
                if (ModConfigs.FREELOOK.shouldInterpolate()) {
                    ((CameraAccessor)camera).setYaw(yaw);
                    ((CameraAccessor)camera).setPitch(pitch);
                    CameraEvents.startInterpolation();
                } else {
                    CameraEvents.reset(camera);
                }
                initialPress = true;
            }
            isFreelooking = false;
        }
    }

    private static void startInterpolation() {
        lerpStart = System.currentTimeMillis();
        isInterpolating = true;
    }

    private static void setup() {
        originalYaw = CameraEvents.getPlayer().m_146908_();
        originalPitch = CameraEvents.getPlayer().m_146909_();
        originalHeadYaw = CameraEvents.getPlayer().f_20885_;
        prevMouseX = CameraEvents.getMinecraft().f_91067_.m_91589_();
        prevMouseY = CameraEvents.getMinecraft().f_91067_.m_91594_();
    }

    private static void updateCameraRotation(Camera camera) {
        double dx = mouseDX * CameraEvents.getSensitivity() * 0.15;
        double dy = mouseDY * CameraEvents.getSensitivity() * 0.15;
        yaw = (float)dx - prevYaw + originalYaw;
        pitch = CameraEvents.getMinecraft().f_91066_.f_92044_ ? (float)dy + prevPitch + originalPitch : (float)dy - prevPitch + originalPitch;
        if (ModConfigs.FREELOOK.shouldClamp()) {
            yaw = Mth.m_14036_((float)yaw, (float)(originalYaw + -100.0f), (float)(originalYaw + 100.0f));
        }
        pitch = Mth.m_14036_((float)pitch, (float)-89.0f, (float)89.0f);
        prevYaw = Mth.m_14036_((float)((float)dx + prevYaw), (float)-99.0f, (float)99.0f);
        prevPitch = Mth.m_14036_((float)((float)dy + prevPitch), (float)-89.0f, (float)89.0f);
        ((CameraAccessor)camera).setYaw(yaw);
        ((CameraAccessor)camera).setPitch(pitch);
    }

    private static void interpolate(Camera camera) {
        double duration = ModConfigs.FREELOOK.getInterpolateSpeed() * 1000.0;
        float delta = System.currentTimeMillis() - lerpStart - lerpTimeElapsed;
        delta = (float)((double)delta / duration);
        float percentCompleted = (float)lerpTimeElapsed / (float)duration;
        float interpolatedYaw = CameraEvents.lerp(yaw, originalYaw, percentCompleted * 10.0f * delta);
        float interpolatedPitch = CameraEvents.lerp(pitch, originalPitch, percentCompleted * 10.0f * delta);
        ((CameraAccessor)camera).setYaw(yaw);
        ((CameraAccessor)camera).setPitch(pitch);
        yaw = interpolatedYaw;
        pitch = interpolatedPitch;
        lerpTimeElapsed = System.currentTimeMillis() - lerpStart;
        if ((double)lerpTimeElapsed >= duration) {
            CameraEvents.reset(camera);
        }
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static void reset(Camera camera) {
        ((CameraAccessor)camera).setYaw(yaw);
        ((CameraAccessor)camera).setPitch(pitch);
        isInterpolating = false;
        lerpTimeElapsed = 0L;
        yaw = 0.0f;
        pitch = 0.0f;
        prevYaw = 0.0f;
        prevPitch = 0.0f;
        mouseDX = 0.0;
        mouseDY = 0.0;
        prevMouseX = 0.0;
        prevMouseY = 0.0;
        player = null;
        minecraft = null;
    }

    private static void lockPlayerRotation() {
        CameraEvents.getPlayer().m_146922_(originalYaw);
        CameraEvents.getPlayer().m_146926_(originalPitch);
        CameraEvents.getPlayer().f_20885_ = originalHeadYaw;
    }

    private static void updateMouseInput() {
        mouseDX = prevMouseX - CameraEvents.getMinecraft().f_91067_.m_91589_();
        mouseDY = prevMouseY - CameraEvents.getMinecraft().f_91067_.m_91594_();
        prevMouseX = CameraEvents.getMinecraft().f_91067_.m_91589_();
        prevMouseY = CameraEvents.getMinecraft().f_91067_.m_91594_();
    }

    private static double getSensitivity() {
        return Math.pow(CameraEvents.getMinecraft().f_91066_.f_92053_ * 0.6 + 0.2, 3.0) * 8.0;
    }

    private static LocalPlayer getPlayer() {
        if (player == null) {
            player = CameraEvents.getMinecraft().f_91074_;
        }
        return player;
    }

    private static Minecraft getMinecraft() {
        if (minecraft == null) {
            minecraft = Minecraft.m_91087_();
        }
        return minecraft;
    }

    public static boolean shouldUpdate() {
        return ModKeybinds.keyFreeLook.m_90857_() || toggle || isFreelooking || isInterpolating;
    }

    static {
        lerpStart = 0L;
        lerpTimeElapsed = 0L;
        initialPress = true;
        isInterpolating = false;
        toggle = false;
        isFreelooking = false;
    }
}

