/*
 * Decompiled with CFR 0.152.
 */
package net.ninjadev.freelook.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public abstract class BaseConfig {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    protected String root = "config/FreeLook/";
    protected String extension = ".json";

    public void generateConfig() {
        this.reset();
        try {
            this.writeConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getConfigFile() {
        return new File(this.root + this.getName() + this.extension);
    }

    public abstract String getName();

    public BaseConfig readConfig() {
        try {
            return (BaseConfig)GSON.fromJson((Reader)new FileReader(this.getConfigFile()), this.getClass());
        }
        catch (FileNotFoundException e) {
            this.generateConfig();
            return this;
        }
    }

    protected abstract void reset();

    public void writeConfig() throws IOException {
        File dir = new File(this.root);
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        if (!this.getConfigFile().exists() && !this.getConfigFile().createNewFile()) {
            return;
        }
        FileWriter writer = new FileWriter(this.getConfigFile());
        GSON.toJson((Object)this, (Appendable)writer);
        writer.flush();
        writer.close();
    }

    public void save() {
        try {
            this.writeConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

