/*
 * Decompiled with CFR 0.152.
 */
package net.ninjadev.freelook.common.config;

import com.google.gson.annotations.Expose;
import net.ninjadev.freelook.common.config.BaseConfig;
import net.ninjadev.freelook.common.config.option.Option;

public class FreeLookConfiguration
extends BaseConfig {
    @Expose
    private Option.BooleanValue clampView;
    @Expose
    private Option.BooleanValue interpolate;
    @Expose
    private Option.DoubleValue interpolateSpeed;

    @Override
    public String getName() {
        return "FreeLook";
    }

    @Override
    protected void reset() {
        this.clampView = new Option.BooleanValue(true, "Clamp your head rotation to your shoulders. As you would expect in real life.");
        this.interpolate = new Option.BooleanValue(true, "Smooth the camera returning to original direction. Instead of snapping back instantly.");
        this.interpolateSpeed = new Option.DoubleValue(0.2, "The time in seconds to move your view back to the original position.");
    }

    public boolean shouldClamp() {
        return (Boolean)this.clampView.getValue();
    }

    public boolean shouldInterpolate() {
        return (Boolean)this.interpolate.getValue();
    }

    public double getInterpolateSpeed() {
        return (Double)this.interpolateSpeed.getValue();
    }
}

