/*
 * Decompiled with CFR 0.152.
 */
package net.ninjadev.freelook.common.event;

import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.ninjadev.freelook.common.init.ModConfigs;
import net.ninjadev.freelook.common.init.ModKeybinds;
import net.ninjadev.freelook.common.util.FreeLookUtil;

public interface ICameraEvents {
    public boolean isInitialPress();

    public void setInitialPress(boolean var1);

    public boolean isInterpolating();

    public void setIsInterpolating(boolean var1);

    public long getLerpTimeElapsed();

    public void setLerpTimeElapsed(long var1);

    public long getLerpStart();

    public void setLerpStart(long var1);

    public boolean isToggle();

    public void setToggle(boolean var1);

    public boolean isFreeLooking();

    public void setFreeLooking(boolean var1);

    public double getMouseDeltaX();

    public double getMouseDeltaY();

    public void setMouseDelta(double var1, double var3);

    public void setPreviousMouse(double var1, double var3);

    public double getPreviousMouseX();

    public double getPreviousMouseY();

    public float getYaw();

    public float getPitch();

    public void setYawPitch(float var1, float var2);

    public float getPreviousYaw();

    public float getPreviousPitch();

    public void setPreviousYawPitch(float var1, float var2);

    public float getOriginalYaw();

    public float getOriginalPitch();

    public float getOriginalHeadYaw();

    public void setOriginalPlayerRotations(float var1, float var2, float var3);

    public Camera getCamera();

    public void setCamera(Camera var1);

    public void setCameraYawPitch(float var1, float var2);

    default public void onClientTick() {
        if (ModKeybinds.keyToggleMode.m_90859_()) {
            this.setToggle(!this.isToggle());
        }
    }

    default public void setup() {
        this.setOriginalPlayerRotations(this.getPlayer().m_146908_(), this.getPlayer().m_146909_(), this.getPlayer().f_20885_);
        this.setPreviousMouse(this.getMinecraft().f_91067_.m_91589_(), this.getMinecraft().f_91067_.m_91594_());
    }

    default public void reset() {
        this.setCameraYawPitch(this.getYaw(), this.getPitch());
        this.setIsInterpolating(false);
        this.setLerpTimeElapsed(0L);
        this.setYawPitch(0.0f, 0.0f);
        this.setPreviousYawPitch(0.0f, 0.0f);
        this.setMouseDelta(0.0, 0.0);
        this.setPreviousMouse(0.0, 0.0);
    }

    default public void onUpdate() {
        if (this.getMinecraft().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
            return;
        }
        if (ModKeybinds.keyFreeLook.m_90857_() || this.isToggle()) {
            this.setFreeLooking(true);
            if (this.isInitialPress()) {
                this.reset();
                this.setup();
                this.setInitialPress(false);
            }
            this.lockPlayerRotation();
            this.updateMouse();
            this.updateCameraRotation();
        } else if (this.isInterpolating()) {
            this.lockPlayerRotation();
            this.interpolate();
        } else {
            if (!this.isInitialPress()) {
                if (ModConfigs.FREELOOK.shouldInterpolate()) {
                    this.setCameraYawPitch(this.getYaw(), this.getPitch());
                    this.startInterpolation();
                } else {
                    this.reset();
                }
                this.setInitialPress(true);
            }
            this.setFreeLooking(false);
        }
    }

    default public void lockPlayerRotation() {
        this.getPlayer().m_146922_(this.getOriginalYaw());
        this.getPlayer().m_146926_(this.getOriginalPitch());
        this.getPlayer().f_20885_ = this.getOriginalHeadYaw();
    }

    default public void updateMouse() {
        double mouseX = this.getMinecraft().f_91067_.m_91589_();
        double mouseY = this.getMinecraft().f_91067_.m_91594_();
        this.setMouseDelta(this.getPreviousMouseX() - mouseX, this.getPreviousMouseY() - mouseY);
        this.setPreviousMouse(mouseX, mouseY);
    }

    default public void updateCameraRotation() {
        float pitch;
        double dx = this.getMouseDeltaX() * this.getSensitivity() * 0.15;
        double dy = this.getMouseDeltaY() * this.getSensitivity() * 0.15;
        float previousYaw = this.getPreviousYaw();
        float previousPitch = this.getPreviousPitch();
        float originalYaw = this.getOriginalYaw();
        float originalPitch = this.getOriginalPitch();
        float yaw = (float)dx - previousYaw + originalYaw;
        float f = pitch = (Boolean)this.getMinecraft().f_91066_.m_231820_().m_231551_() != false ? (float)dy + previousPitch + previousYaw : (float)dy - previousPitch + originalPitch;
        if (ModConfigs.FREELOOK.shouldClamp()) {
            yaw = Mth.m_14036_((float)yaw, (float)(originalYaw + -100.0f), (float)(originalYaw + 100.0f));
        }
        pitch = Mth.m_14036_((float)pitch, (float)-89.0f, (float)89.0f);
        this.setYawPitch(yaw, pitch);
        this.setPreviousYawPitch(Mth.m_14036_((float)((float)dx + previousYaw), (float)-99.0f, (float)99.0f), Mth.m_14036_((float)((float)dy + previousPitch), (float)-89.0f, (float)89.0f));
        this.setCameraYawPitch(this.getYaw(), this.getPitch());
    }

    default public void startInterpolation() {
        this.setLerpStart(System.currentTimeMillis());
        this.setIsInterpolating(true);
    }

    default public void interpolate() {
        double duration = ModConfigs.FREELOOK.getInterpolateSpeed() * 1000.0;
        float delta = System.currentTimeMillis() - this.getLerpStart() - this.getLerpTimeElapsed();
        delta = (float)((double)delta / duration);
        float percentCompleted = (float)this.getLerpTimeElapsed() / (float)duration;
        float interpolatedYaw = FreeLookUtil.lerp(this.getYaw(), this.getOriginalYaw(), percentCompleted * 10.0f * delta);
        float interpolatedPitch = FreeLookUtil.lerp(this.getPitch(), this.getOriginalPitch(), percentCompleted * 10.0f * delta);
        this.setCameraYawPitch(this.getYaw(), this.getPitch());
        this.setYawPitch(interpolatedYaw, interpolatedPitch);
        this.setLerpTimeElapsed(System.currentTimeMillis() - this.getLerpStart());
        if ((double)this.getLerpTimeElapsed() >= duration) {
            this.reset();
        }
    }

    default public Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    default public LocalPlayer getPlayer() {
        return this.getMinecraft().f_91074_;
    }

    private double getSensitivity() {
        return Math.pow((Double)this.getMinecraft().f_91066_.m_231964_().m_231551_() * 0.6 + 0.2, 3.0) * 8.0;
    }

    default public boolean shouldUpdate() {
        return ModKeybinds.keyFreeLook.m_90857_() || this.isToggle() || this.isFreeLooking() || this.isInterpolating();
    }
}

