/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm;

import baguchan.frostrealm.capability.ColdCapability;
import baguchan.frostrealm.capability.ColdStorage;
import baguchan.frostrealm.client.ClientRegistrar;
import baguchan.frostrealm.client.event.ClientColdHUDEvent;
import baguchan.frostrealm.command.SetWeatherCommand;
import baguchan.frostrealm.data.FRBlockStates;
import baguchan.frostrealm.data.FRBlockTags;
import baguchan.frostrealm.data.FREntityTags;
import baguchan.frostrealm.data.FRItemModels;
import baguchan.frostrealm.data.FRItemTags;
import baguchan.frostrealm.data.FRLang;
import baguchan.frostrealm.data.FRLootTables;
import baguchan.frostrealm.data.FRRecipes;
import baguchan.frostrealm.event.WeatherHandler;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostCarvers;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostEntityTypes;
import baguchan.frostrealm.register.FrostFeatures;
import baguchan.frostrealm.register.FrostFluids;
import baguchan.frostrealm.register.FrostItems;
import baguchan.frostrealm.register.FrostMemoryModules;
import baguchan.frostrealm.register.FrostSensers;
import baguchan.frostrealm.register.FrostSounds;
import baguchan.frostrealm.register.FrostStructures;
import baguchan.frostrealm.register.FrostTileEntities;
import baguchan.frostrealm.register.FrostWeatherSystem;
import baguchan.frostrealm.weather.Clear;
import baguchan.frostrealm.world.data.FrostWeatherData;
import java.util.Locale;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="frostrealm")
public class FrostRealm {
    public static final Logger LOGGER = LogManager.getLogger((String)"frostrealm");
    public static final String MODID = "frostrealm";
    public static final Clear DUMMY_CLEAR = new Clear();
    public static final String NETWORK_PROTOCOL = "2";
    @CapabilityInject(value=ColdCapability.class)
    public static final Capability<ColdCapability> COLD_CAP = null;

    public FrostRealm() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::lateSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherData);
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        FrostBlocks.BLOCKS.register(modbus);
        FrostCarvers.CARVERS.register(modbus);
        FrostEntityTypes.ENTITIES.register(modbus);
        FrostMemoryModules.MEMORY_MODULES_TYPE.register(modbus);
        FrostSensers.SENSOR_TYPE.register(modbus);
        FrostFluids.FLUIDS.register(modbus);
        FrostItems.ITEMS.register(modbus);
        FrostFeatures.FEATURES.register(modbus);
        FrostSounds.SOUNDS.register(modbus);
        FrostStructures.STRUCTURES.register(modbus);
        FrostTileEntities.TILE_ENTITIES.register(modbus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientRegistrar::setup));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ColdCapability.class, new ColdStorage(), ColdCapability::new);
        event.enqueueWork(() -> {
            FrostEntityTypes.spawnPlacements();
            FrostFeatures.registerConfiguredFeatures();
            FrostCarvers.registerConfiguredCarvers();
            FrostStructures.registerStructures();
            FrostDimensions.registerDimensionStuff();
        });
        FrostWeatherSystem.addDefaultWeatherEvents();
        NetworkHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)WeatherHandler.INSTANCE);
    }

    public void lateSetup(FMLLoadCompleteEvent event) {
        FrostWeatherSystem.fillWeatherEventsMapAndWeatherEventController();
        FrostWeatherData.currentWeather = DUMMY_CLEAR;
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientColdHUDEvent());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register(SetWeatherCommand.getWeatherCommandNode());
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MODID, name.toLowerCase(Locale.ROOT));
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new FRBlockStates(generator, helper));
            generator.func_200390_a((IDataProvider)new FRItemModels(generator, helper));
            generator.func_200390_a((IDataProvider)new FRLang(generator));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new FRRecipes(generator));
            generator.func_200390_a((IDataProvider)new FRLootTables(generator));
            FRBlockTags blockTags = new FRBlockTags(generator, helper);
            generator.func_200390_a((IDataProvider)blockTags);
            generator.func_200390_a((IDataProvider)new FRItemTags(generator, blockTags, helper));
            generator.func_200390_a((IDataProvider)new FREntityTags(generator, helper));
        }
    }
}

