/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.world.FrostWorldTeleporter;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class FrostPortalBlock
extends BreakableBlock {
    public FrostPortalBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean trySpawnPortal(World worldIn, BlockPos pos) {
        Size size1 = new Size((IWorld)worldIn, pos);
        if (size1.isValid()) {
            size1.placePortalBlocks();
            worldIn.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean good = world.func_180495_p(pos.func_177977_b()).func_200132_m();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!good) break;
            BlockState neighboringState = world.func_180495_p(pos.func_177972_a(facing));
            good = neighboringState.func_177230_c() == Blocks.field_196604_cC || neighboringState == state;
        }
        if (!good) {
            world.func_175669_a(2001, pos, Block.func_196246_j((BlockState)state));
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
        }
    }

    public void func_196262_a(BlockState p_196262_1_, World p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
        super.func_196262_a(p_196262_1_, p_196262_2_, p_196262_3_, p_196262_4_);
        if (p_196262_4_.func_242280_ah()) {
            p_196262_4_.field_242273_aw = 100;
        } else if (p_196262_2_ instanceof ServerWorld) {
            FrostPortalBlock.attemptSendPlayer(p_196262_4_, (ServerWorld)p_196262_2_);
        }
    }

    private static RegistryKey<World> getDestination(Entity entity) {
        return entity.field_70170_p.func_234923_W_() == World.field_234918_g_ ? FrostDimensions.frostrealm : World.field_234918_g_;
    }

    public static void attemptSendPlayer(Entity entity, ServerWorld oldworld) {
        if (!entity.func_70089_S() || entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU()) {
            return;
        }
        RegistryKey<World> destination = FrostPortalBlock.getDestination(entity);
        ServerWorld serverWorld = oldworld.func_73046_m().func_71218_a(destination);
        if (serverWorld == null) {
            return;
        }
        entity.field_70170_p.func_217381_Z().func_76320_a("portal");
        entity.changeDimension(serverWorld, (ITeleporter)new FrostWorldTeleporter());
        entity.field_242273_aw = 100;
        entity.field_70170_p.func_217381_Z().func_76319_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int random = rand.nextInt(100);
        if (random == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double xPos = (float)pos.func_177958_n() + rand.nextFloat();
            double yPos = (double)pos.func_177956_o() + 1.0;
            double zPos = (float)pos.func_177952_p() + rand.nextFloat();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = rand.nextFloat();
            double d = ((double)rand.nextFloat() - 0.5) * 0.5;
        }
    }

    public static class Size {
        private static final int MAX_SIZE = 12;
        private static final int MIN_SIZE = 2;
        private final IWorld world;
        private boolean valid = false;
        private BlockPos nw;
        private BlockPos se;

        public Size(IWorld world, BlockPos pos) {
            this.world = world;
            int east = this.getDistanceUntilEdge(pos, Direction.EAST);
            int west = this.getDistanceUntilEdge(pos, Direction.WEST);
            int north = this.getDistanceUntilEdge(pos, Direction.NORTH);
            int south = this.getDistanceUntilEdge(pos, Direction.SOUTH);
            int width = east + west - 1;
            int length = north + south - 1;
            if (width > 12 || length > 12) {
                return;
            }
            if (width < 2 || length < 2) {
                return;
            }
            BlockPos neCorner = pos.func_177965_g(east).func_177964_d(north);
            BlockPos nwCorner = pos.func_177985_f(west).func_177964_d(north);
            BlockPos seCorner = pos.func_177965_g(east).func_177970_e(south);
            BlockPos swCorner = pos.func_177985_f(west).func_177970_e(south);
            this.nw = nwCorner.func_177982_a(1, 0, 1);
            this.se = seCorner.func_177982_a(-1, 0, -1);
            int wallWidth = width + 2;
            int wallLength = length + 2;
            for (int y = 0; y <= 1; ++y) {
                for (int x = 0; x < wallWidth; ++x) {
                    for (int z = 0; z < wallLength; ++z) {
                        if ((y != 0 || x == 0 || z == 0 || x == wallWidth - 1 || z == wallLength - 1) && (y != 1 || x != 0 && z != 0 && x != wallWidth - 1 && z != wallLength - 1) || this.isSnowBlock(world.func_180495_p(nwCorner.func_177977_b().func_177982_a(x, y, z)))) continue;
                        return;
                    }
                }
            }
            this.valid = true;
        }

        int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 9 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.isSnowBlock(this.world.func_180495_p(blockpos.func_177977_b())); ++i) {
            }
            BlockState state = this.world.func_180495_p(pos.func_177967_a(facing, i));
            return this.isSnowBlock(state) ? i : 0;
        }

        boolean isEmptyBlock(BlockState state) {
            return state.func_177230_c() == Blocks.field_150355_j;
        }

        boolean isSnowBlock(BlockState state) {
            return state.func_177230_c() == Blocks.field_196604_cC;
        }

        public boolean isValid() {
            return this.valid;
        }

        void placePortalBlocks() {
            for (BlockPos portalPos : BlockPos.Mutable.func_218278_a((BlockPos)this.nw, (BlockPos)this.se)) {
                this.world.func_180501_a(portalPos, ((FrostPortalBlock)FrostBlocks.FROST_PORTAL.get()).func_176223_P(), 2);
            }
        }
    }
}

