/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.capability;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.network.ChangedColdPacket;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class ColdCapability
implements ICapabilityProvider,
ICapabilitySerializable<CompoundNBT> {
    protected int temperature = 20;
    protected float temperatureSaturation;
    private int tickTimer;
    private float exhaustionLevel;
    private int lastTemperate = 20;
    private BlockPos hotSource;

    public void addExhaustion(float p_75113_1_) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + p_75113_1_, 40.0f);
    }

    public void addHot(int p_75122_1_, float p_75122_2_) {
        this.temperature = Math.min(p_75122_1_ + this.temperature, 20);
        this.temperatureSaturation = Math.min(this.temperatureSaturation + (float)p_75122_1_ * p_75122_2_ * 2.0f, (float)this.temperature);
    }

    public void eatHotFood(Item p_221410_1_, ItemStack p_221410_2_) {
        if (p_221410_1_.func_219971_r()) {
            Food temperature = p_221410_1_.func_219967_s();
            this.addHot(temperature.func_221466_a() / 2, temperature.func_221469_b() * 1.2f);
        }
    }

    public void tick(LivingEntity livingentity) {
        if (livingentity.field_70170_p.func_234923_W_() == FrostDimensions.frostrealm && (!FrostTags.Entities.IMMUNE_COLD.func_230235_a_((Object)livingentity.func_200600_R()) || livingentity instanceof PlayerEntity && (((PlayerEntity)livingentity).func_184812_l_() || ((PlayerEntity)livingentity).func_175149_v()))) {
            Difficulty difficulty = livingentity.field_70170_p.func_175659_aa();
            this.lastTemperate = this.temperature;
            this.hotSourceTick(livingentity);
            float tempAffect = 1.0f;
            if (!livingentity.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
                tempAffect *= 0.9f;
            }
            if (!livingentity.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
                tempAffect *= 0.75f;
            }
            if (!livingentity.func_184582_a(EquipmentSlotType.LEGS).func_190926_b()) {
                tempAffect *= 0.75f;
            }
            if (!livingentity.func_184582_a(EquipmentSlotType.FEET).func_190926_b()) {
                tempAffect *= 0.9f;
            }
            if (this.hotSource != null) {
                this.addExhaustion(tempAffect * 0.005f);
                if (this.exhaustionLevel > 4.0f) {
                    this.exhaustionLevel -= 4.0f;
                    if (this.temperatureSaturation > 0.0f) {
                        this.temperatureSaturation = Math.max(this.temperatureSaturation - 0.1f, 0.0f);
                    } else if (difficulty != Difficulty.PEACEFUL) {
                        this.temperature = Math.max(this.temperature - 1, 0);
                    }
                }
            }
            if (FrostTags.Entities.WEAK_COLD.func_230235_a_((Object)livingentity.func_200600_R())) {
                this.temperature = Math.max(this.temperature - 1, 0);
                this.temperatureSaturation = 0.0f;
                livingentity.func_70097_a(DamageSource.field_76366_f, 1.0f);
            } else if (this.temperature <= 0) {
                ++this.tickTimer;
                if (this.tickTimer >= 80) {
                    if (livingentity.func_110143_aJ() > 4.0f || difficulty == Difficulty.HARD || difficulty == Difficulty.NORMAL) {
                        livingentity.func_70097_a(DamageSource.field_76366_f, 1.0f);
                    }
                    this.tickTimer = 0;
                }
            } else {
                this.tickTimer = 0;
            }
        } else {
            if (this.temperatureSaturation < 1.0f) {
                this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.1f, 1.0f);
            } else {
                this.temperature = Math.min(this.temperature + 1, 20);
            }
            this.exhaustionLevel = 0.0f;
        }
        if (livingentity.field_70173_aa % 10 == 0 && !livingentity.field_70170_p.func_201670_d()) {
            ChangedColdPacket message = new ChangedColdPacket((Entity)livingentity, this.temperature, this.temperatureSaturation);
            NetworkHandler.SIMPLE_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingentity), (Object)message);
        }
    }

    private void hotSourceTick(LivingEntity livingentity) {
        if (this.hotSource == null || !this.hotSource.func_218137_a((IPosition)livingentity.func_213303_ch(), 3.46) || !livingentity.field_70170_p.func_180495_p(this.hotSource).func_235714_a_(FrostTags.Blocks.HOT_SOURCE) || livingentity.field_70170_p.func_180495_p(this.hotSource).func_177230_c() instanceof CampfireBlock && !CampfireBlock.func_226915_i_((BlockState)livingentity.field_70170_p.func_180495_p(this.hotSource))) {
            this.hotSource = null;
        }
        if (this.hotSource == null) {
            int heatRange = 2;
            int entityPosX = (int)livingentity.func_226277_ct_();
            int entityPosY = (int)livingentity.func_226278_cu_();
            int entityPosZ = (int)livingentity.func_226281_cx_();
            if (livingentity.field_70173_aa % 20 == 0) {
                for (int hX = entityPosX - heatRange; hX <= entityPosX + heatRange; ++hX) {
                    for (int hY = entityPosY - 2; hY <= entityPosY; ++hY) {
                        for (int hZ = entityPosZ - heatRange; hZ <= entityPosZ + heatRange; ++hZ) {
                            if (!livingentity.field_70170_p.func_180495_p(new BlockPos(hX, hY, hZ)).func_235714_a_(FrostTags.Blocks.HOT_SOURCE)) continue;
                            this.hotSource = new BlockPos(hX, hY, hZ);
                        }
                    }
                }
            }
        }
        if (this.hotSource != null && this.hotSource.func_218137_a((IPosition)livingentity.func_213303_ch(), 3.46) && livingentity.field_70173_aa % 20 == 0) {
            this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.1f, 1.0f);
            this.temperature = Math.min(this.temperature + 1, 20);
        }
    }

    public int getTemperatureLevel() {
        return this.temperature;
    }

    public float getSaturationLevel() {
        return this.temperatureSaturation;
    }

    public void setTemperatureLevel(int p_75114_1_) {
        this.temperature = p_75114_1_;
    }

    public void setSaturation(float p_75119_1_) {
        this.temperatureSaturation = p_75119_1_;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == FrostRealm.COLD_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("temperatureLevel", this.temperature);
        nbt.func_74768_a("temperatureTickTimer", this.tickTimer);
        nbt.func_74776_a("temperatureSaturationLevel", this.temperatureSaturation);
        nbt.func_74776_a("temperatureExhaustionLevel", this.exhaustionLevel);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("temperatureLevel", 99)) {
            this.temperature = nbt.func_74762_e("temperatureLevel");
            this.tickTimer = nbt.func_74762_e("temperatureTickTimer");
            this.temperatureSaturation = nbt.func_74760_g("temperatureSaturationLevel");
            this.exhaustionLevel = nbt.func_74760_g("temperatureExhaustionLevel");
        }
    }
}

