/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.command;

import baguchan.frostrealm.api.Weather;
import baguchan.frostrealm.network.NetworkHandler;
import baguchan.frostrealm.network.WeatherPacket;
import baguchan.frostrealm.register.FrostDimensions;
import baguchan.frostrealm.register.FrostWeatherSystem;
import baguchan.frostrealm.world.data.FrostWeatherData;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class SetWeatherCommand {
    public static LiteralArgumentBuilder<CommandSource> getWeatherCommandNode() {
        List weatherTypes = FrostWeatherSystem.WEATHER_EVENTPOINT.stream().map(Weather::getID).map(ResourceLocation::toString).collect(Collectors.toList());
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"frostweather").then(Commands.func_197056_a((String)"weathertype", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(weatherTypes.stream(), (SuggestionsBuilder)sb)).executes(cs -> SetWeatherCommand.setWeatherType(((CommandSource)cs.getSource()).func_197023_e(), (CommandSource)cs.getSource(), StringArgumentType.getString((CommandContext)cs, (String)"weathertype"))));
    }

    public static int setWeatherType(ServerWorld world, CommandSource source, String weatherType) {
        Weather weatherEvent = FrostWeatherSystem.WEATHER_EVENTS.get(new ResourceLocation(weatherType));
        Weather previousWeatherEvent = FrostWeatherData.currentWeather;
        if (weatherEvent != null) {
            if (world.func_234923_W_() == FrostDimensions.frostrealm) {
                FrostWeatherData.get((IWorld)world).setEvent(weatherEvent.getID().toString());
                FrostWeatherData.get((IWorld)world).setRainTime(6000);
                source.func_197023_e().func_217490_a(LivingEntity::func_70089_S).forEach(player -> NetworkHandler.sendToClient(player, new WeatherPacket(FrostWeatherData.get((IWorld)world).getEventString())));
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.frostrealm.weather.success", new Object[]{weatherType}), true);
            } else {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.frostrealm.weather.fail.not_frostrealm"));
            }
        } else {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.frostrealm.weather.fail", new Object[]{weatherType}));
        }
        return 1;
    }
}

