/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data;

import baguchan.frostrealm.block.SugarBeetBlock;
import baguchan.frostrealm.data.provider.FRBlockLootTableProvider;
import baguchan.frostrealm.register.FrostBlocks;
import baguchan.frostrealm.register.FrostEntityTypes;
import baguchan.frostrealm.register.FrostItems;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FRLootTables
extends LootTableProvider {
    private static final ILootCondition.IBuilder HAS_SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    private static final ILootCondition.IBuilder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.func_216298_a();
    private static final ILootCondition.IBuilder HAS_SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
    private static final ILootCondition.IBuilder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.func_216297_a(HAS_SILK_TOUCH);
    private static final ILootCondition.IBuilder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.func_216298_a();
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = (Set)Stream.of(net.minecraft.block.Blocks.field_150380_bt, net.minecraft.block.Blocks.field_150461_bJ, net.minecraft.block.Blocks.field_205165_jY, net.minecraft.block.Blocks.field_196703_eM, net.minecraft.block.Blocks.field_196705_eO, net.minecraft.block.Blocks.field_196710_eS, net.minecraft.block.Blocks.field_196708_eQ, net.minecraft.block.Blocks.field_196714_eU, net.minecraft.block.Blocks.field_196716_eW, net.minecraft.block.Blocks.field_204409_il, net.minecraft.block.Blocks.field_190975_dA, net.minecraft.block.Blocks.field_190988_dw, net.minecraft.block.Blocks.field_190989_dx, net.minecraft.block.Blocks.field_190986_du, net.minecraft.block.Blocks.field_190984_ds, net.minecraft.block.Blocks.field_190990_dy, net.minecraft.block.Blocks.field_190980_do, net.minecraft.block.Blocks.field_196875_ie, net.minecraft.block.Blocks.field_190982_dq, net.minecraft.block.Blocks.field_190979_dn, net.minecraft.block.Blocks.field_190978_dm, net.minecraft.block.Blocks.field_190983_dr, net.minecraft.block.Blocks.field_190987_dv, net.minecraft.block.Blocks.field_190991_dz, net.minecraft.block.Blocks.field_190977_dl, net.minecraft.block.Blocks.field_190981_dp).map(IItemProvider::func_199767_j).collect(ImmutableSet.toImmutableSet());
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public FRLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    public String func_200397_b() {
        return "FrostRealm LootTables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(Entities::new, (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
    }

    private static LootTable.Builder dropSeedsForStem(Block stem, Item stemSeed) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)FRLootTables.withExplosionDecay((IItemProvider)stem, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)stemSeed).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.53333336f))))));
    }

    protected static <T> T withExplosionDecay(IItemProvider item, ILootFunctionConsumer<T> function) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(item.func_199767_j()) ? function.func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()) : function.func_212862_c_());
    }

    public static class Entities
    extends EntityLootTables {
        protected void addTables() {
            this.func_218582_a((EntityType)FrostEntityTypes.CRYSTAL_FOX.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)FrostEntityTypes.GOKKUR.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)FrostItems.FROST_CRYSTAL.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)FrostEntityTypes.YETI.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)FrostItems.YETI_FUR.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)FrostEntityTypes.WOLFESTER.get(), LootTable.func_216119_b());
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return FrostEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }

    public static class Blocks
    extends FRBlockLootTableProvider {
        protected void addTables() {
            this.dropWithSilk((Supplier<? extends Block>)FrostBlocks.FROZEN_GRASS_BLOCK, (Supplier<? extends IItemProvider>)FrostBlocks.FROZEN_DIRT);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROZEN_DIRT);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE);
            this.slab((Supplier<? extends SlabBlock>)FrostBlocks.FRIGID_STONE_SLAB);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_BRICK);
            this.slab((Supplier<? extends SlabBlock>)FrostBlocks.FRIGID_STONE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FRIGID_STONE_SMOOTH_BRICK);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_LOG);
            this.func_218522_a((Block)FrostBlocks.FROSTROOT_LEAVES.get(), leaves -> Blocks.func_218540_a((Block)leaves, (Block)((Block)FrostBlocks.FROSTROOT_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(HAS_NO_SHEARS_OR_SILK_TOUCH).func_216045_a(((StandaloneLootEntry.Builder)Blocks.func_218560_a((IItemProvider)((IItemProvider)FrostBlocks.FROSTROOT_LEAVES.get()), (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)FrostItems.FROZEN_FRUIT.get())))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f})))));
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_SAPLING);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_PLANKS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_PLANKS_SLAB);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_PLANKS_STAIRS);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_FENCE);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTROOT_FENCE_GATE);
            this.dropWithSilk((Supplier<? extends Block>)FrostBlocks.FROST_CRYSTAL_ORE, (Supplier<? extends IItemProvider>)FrostItems.FROST_CRYSTAL);
            this.dropWithSilk((Supplier<? extends Block>)FrostBlocks.GLIMMERROCK_ORE, (Supplier<? extends IItemProvider>)FrostItems.GLIMMERROCK);
            this.dropSelf((Supplier<? extends Block>)FrostBlocks.FROSTBULB_MUSHROOM);
            BlockStateProperty.Builder ilootcondition$ibuilder = BlockStateProperty.func_215985_a((Block)((Block)FrostBlocks.SUGARBEETS.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)SugarBeetBlock.AGE, 3));
            this.func_218507_a((Block)FrostBlocks.SUGARBEETS.get(), Blocks.func_218541_a((Block)((Block)FrostBlocks.SUGARBEETS.get()), (Item)((Item)FrostItems.SUGARBEET.get()), (Item)((Item)FrostItems.SUGARBEET_SEEDS.get()), (ILootCondition.IBuilder)ilootcondition$ibuilder));
            this.func_218507_a((Block)FrostBlocks.HOT_SPRING.get(), Blocks.func_218482_a());
            this.dropOther((Supplier<? extends Block>)FrostBlocks.FROZEN_FARMLAND, (IItemProvider)FrostBlocks.FROZEN_DIRT.get());
            this.dropOther((Supplier<? extends Block>)FrostBlocks.FROST_TORCH, (IItemProvider)FrostItems.FROST_TORCH.get());
            this.dropOther((Supplier<? extends Block>)FrostBlocks.WALL_FROST_TORCH, (IItemProvider)FrostItems.FROST_TORCH.get());
            this.dropOther((Supplier<? extends Block>)FrostBlocks.FROST_CAMPFIRE, (IItemProvider)FrostItems.FROST_CRYSTAL.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return FrostBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

